<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;


function getCountMessageAndRequestCoach($myId)
{

    global $connect;
    $requestCount = 0;
    $messageCount = 0;

    $queryRequestCount = "SELECT COUNT(t_request.id) requestCount FROM tbl_request_plan AS t_request JOIN tbl_coaching_team AS t_coach ON t_request.coachId = t_coach.id  WHERE (86400 - (UNIX_TIMESTAMP() - t_request.requestDateSec)) > 0 AND t_coach.clientId = '$myId' AND t_request.seen = 0";

    $res = $connect->prepare($queryRequestCount);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetch(PDO::FETCH_ASSOC);
        $requestCount = $rows['requestCount'];
    }
    $queryMessageCount = "SELECT COUNT(id) messageCount FROM tbl_chat WHERE receiver_id = '$myId' AND seen = 0";

    $res = $connect->prepare($queryMessageCount);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetch(PDO::FETCH_ASSOC);
        $messageCount = $rows['messageCount'];
    }
    $counterNotif = new stdClass();
    $counterNotif->requestCount = $requestCount;
    $counterNotif->messageCount = $messageCount;
    $data = ["Data" => $counterNotif];
    Response::respondAndDieFun($data,  'get successfully message');
}
function getRequestList($coachClientId, $Page, $searchText)
{
    global $connect;
    $pagingItem = PAGING_ITEM;
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    // $query = "SELECT t_request.id AS requestId, t_clientType.profileImage AS profileImage, CONCAT(t_clientType.firstName,' ',t_clientType.lastName) AS profielName, ( (t_request.requestDateSec + '86400')-t_request.requestDateSec ) AS remainingTimeRequest, DATE_FORMAT(t_request.requestDate, '%H:%i') AS inserTime, t_request.acceptCoach AS acceptCoach FROM `tbl_request_plan` AS t_request JOIN tbl_client AS t_client ON t_request.clientId = t_client.id JOIN tbl_client_type AS t_clientType ON t_client.id = t_clientType.client_id WHERE `coachId` = '$coachClientId' ORDER BY t_request.id ASC LIMIT $page,$pagingItem;";
    $query = "SELECT 
            t_request.id AS requestId, 
            t_clientType.profileImage AS profileImage, 
            CONCAT(t_clientType.firstName, ' ', t_clientType.lastName) AS profileName,
            (86400 - (UNIX_TIMESTAMP() - t_request.requestDateSec)) AS remainingTimeRequest, -- زمان باقی‌مانده تا 24 ساعت
            DATE_FORMAT(t_request.requestDate, '%H:%i') AS insertTime, 
            t_request.acceptCoach AS acceptCoach 
        FROM 
            `tbl_request_plan` AS t_request 
            INNER JOIN tbl_client AS t_client ON t_request.clientId = t_client.id 
            INNER JOIN tbl_client_type AS t_clientType ON t_client.id = t_clientType.client_id 
        WHERE 
            t_client.id = '$coachClientId' AND CONCAT(t_clientType.firstName,' ',t_clientType.lastName) LIKE '%$searchText%'
            AND (86400 - (UNIX_TIMESTAMP() - t_request.requestDateSec)) >0
        ORDER BY 
            t_request.id ASC 
        LIMIT  0, 15";

    $stmt = $connect->prepare($query);
    $stmt->execute();
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $data = ["request" => $row];
        Response::respondAndDieFun($data,  'tnx, send request plan');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function getMessageList($myId, $clientId, $lastMessageIndex)
{
    global $connect;
    $pagingItem = PAGING_ITEM;
    // $pagingItem = 7;
    $clientId = checkSqlInjection($clientId);
    $lastMessageIndex = checkSqlInjection($lastMessageIndex);

    // $myId = 19;
    // $clientId = 13;


    $query = "";
    if ($lastMessageIndex == 0) {
        // t_ct.profileImage AS profileImage,

        $query = "SELECT 
            t_chat.id AS messageId,
            t_chat.writerType AS writerType,
            t_chat.sender_id AS senderId,
            t_chat.receiver_id AS receiverId,
            CONCAT(t_ct.firstName, ' ', t_ct.lastName) AS senderName,
            t_chat.messageType AS messageType,
            t_chat.messageText AS messageText,
            t_chat.tblPlanId AS tblPlanId,
            t_chat.photoUrl AS photoUrl,
            t_chat.replyToMessageId AS replyToMessageId,
            t_chat.voiceUrl AS voiceUrl,
            DATE_FORMAT(t_chat.insertDate, '%Y-%m-%d %H:%i:%s') AS messageDate,
            t_chat.insertDateSec AS timestamp,
            t_chat.seen AS isSeen,
            CASE 
                WHEN t_chat.sender_id = $myId THEN 1
                ELSE 0
            END AS isSender
        FROM 
            tbl_chat AS t_chat
        JOIN 
            tbl_client_type AS t_ct ON t_chat.sender_id = t_ct.client_id
        WHERE 
            (t_chat.sender_id = $myId AND t_chat.receiver_id = $clientId)
            OR 
            (t_chat.sender_id = $clientId AND t_chat.receiver_id = $myId)
        ORDER BY 
            t_chat.id DESC
        LIMIT $pagingItem;";
    } else {
        $query = "SELECT 
                t_chat.id AS messageId,
                t_chat.writerType AS writerType,
                t_chat.sender_id AS senderId,
                t_chat.receiver_id AS receiverId,
                CONCAT(t_ct.firstName, ' ', t_ct.lastName) AS senderName,
                t_chat.messageType AS messageType,
                t_chat.messageText AS messageText,
                t_ct.profileImage AS profileImage,
                t_chat.tblPlanId AS tblPlanId,
                t_chat.photoUrl AS photoUrl,
                t_chat.replyToMessageId AS replyToMessageId,
                t_chat.voiceUrl AS voiceUrl,
                DATE_FORMAT(t_chat.insertDate, '%Y-%m-%d %H:%i:%s') AS messageDate,
                t_chat.insertDateSec AS timestamp,
                t_chat.seen AS isSeen,
                CASE 
                    WHEN t_chat.sender_id = $myId THEN 1
                    ELSE 0
                END AS isSender
        FROM 
            tbl_chat AS t_chat
        JOIN 
            tbl_client_type AS t_ct ON t_chat.sender_id = t_ct.client_id
        WHERE 
            ((t_chat.sender_id = $myId AND t_chat.receiver_id = $clientId)
            OR 
            (t_chat.sender_id = $clientId AND t_chat.receiver_id = $myId))
            AND
            t_chat.id < $lastMessageIndex
        ORDER BY 
            t_chat.id DESC
        LIMIT 0,$pagingItem;";
    }
    // echo  $query;
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetchAll(PDO::FETCH_ASSOC);
        for ($i = 0; $i < sizeof($rows); $i++) {
            $row = $rows[$i];
            $messageData = _getDataMessageType($myId, $row);
            $rows[$i]["messageData"] = $messageData;
        }

        $data = ["messages" => $rows];
        Response::respondAndDieFun($data,  'get successfully message');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function _getDataMessageType($myId, $row)
{
    global $connect;
    $messageType = $row["messageType"];

    $messageData = new stdClass();
    switch ($messageType) {
        case 0:
            // default_meesage = 0
            $messageData->data = $row["messageText"];
            break;
        case 1:
            // plan_type = 1
            $tblPlanId = $row["tblPlanId"];
            $queryPlan = "SELECT `id`, `clientId`, `haveWorkOutPlan`, `workOutName`, `workOutTrainingDays`, `workOutPlanDuration`, `haveNutritionPlan`, `nutritionName`, `nutritionTrainingDays`, `nutritionPlanDuration`, `createDate`, `createDateSec` FROM `tbl_plans` WHERE `id` = $tblPlanId ";
            $res = $connect->prepare($queryPlan);
            $res->execute();
            if ($res->rowCount() > 0) {
                $rowPlan = $res->fetch(PDO::FETCH_ASSOC);
                $coachId = $rowPlan['clientId'];
                $coachName = "";

                $queryCoachName = "SELECT id, CONCAT(`firstName`,' ',`lastName`) AS coachName FROM `tbl_coaching_team` WHERE `clientId` = '$coachId'";

                $resCoachName = $connect->prepare($queryCoachName);
                $resCoachName->execute();
                if ($resCoachName->rowCount() > 0) {
                    $rowCoach = $resCoachName->fetch(PDO::FETCH_ASSOC);
                    $coachName = $rowCoach["coachName"];
                }

                $plans = [];

                if ($rowPlan['haveWorkOutPlan'] == 1) {
                    $expire = getExpirePlan($tblPlanId, 'workout', $myId);
                    $planData = new stdClass();
                    $planData->planId =  $tblPlanId;
                    $planData->expire =  $expire;
                    $planData->planType = "workOut";
                    $planData->planName = $rowPlan['workOutName'];
                    $planData->coachName = $coachName;
                    $planData->coachId = $coachId;
                    $planData->createDate = $rowPlan['createDate'];
                    $planData->trainingDayInWeek = $rowPlan['workOutTrainingDays'];
                    $planData->durationWeek = $rowPlan['workOutPlanDuration'];
                    $plans[] = $planData;
                }

                if ($rowPlan['haveNutritionPlan'] == 1) {
                    $expire = getExpirePlan($tblPlanId, 'nutrition', $myId);
                    $planData = new stdClass();
                    $planData->planId =  $tblPlanId;
                    $planData->expire =  $expire;
                    $planData->planType = "nutrition";
                    $planData->planName = $rowPlan['nutritionName'];
                    $planData->coachId = $coachId;
                    $planData->coachName = $coachName;
                    $planData->createDate = $rowPlan['createDate'];
                    $planData->trainingDayInWeek = $rowPlan['nutritionTrainingDays'];
                    $planData->durationWeek = $rowPlan['nutritionPlanDuration'];
                    $plans[] = $planData;
                }
                $messageData->data = $plans;
            }
            break;
        case 2:
            // photo = 2
            $messageData->data = $row["photoUrl"];
            break;
        case 3:
            // text = 3
            $messageData->data = $row["messageText"];
            break;
        case 4:
            // reply = 4
            $replyedMesaageId = $row["replyToMessageId"];
            $messageText = $row["messageText"];

            $replyData = new stdClass();
            $replyData->replyToMessageType = null;
            $replyData->baseMessageId = $replyedMesaageId;
            $replyData->baseMessage = null;
            $replyData->messageText = $messageText;


            $queryReply = "SELECT `id`, `messageType`, `messageText`, `tblPlanId`, `photoUrl`, `replyToMessageId`, `voiceUrl` FROM `tbl_chat` WHERE `id` = $replyedMesaageId ";
            $resReply = $connect->prepare($queryReply);
            $resReply->execute();
            if ($resReply->rowCount() > 0) {
                $rowReply = $resReply->fetch(PDO::FETCH_ASSOC);
                $replyToMessageType = $rowReply["messageType"];
                $replyData->replyToMessageType = $replyToMessageType;

                switch ($replyToMessageType) {
                    case 1:
                        // baseMessage = 'plan message'
                        $replyData->baseMessage = 'plan message';
                        break;
                    case 2:
                        // baseMessage = 'photo message'
                        $replyData->baseMessage = 'photo message';
                        break;
                    case 3:
                        // baseMessage = text
                        $replyData->baseMessage =  $rowReply["messageText"];
                        break;
                    case 4:
                        // baseMessage = 'reply message'
                        $replyData->baseMessage =  $rowReply["messageText"];
                        break;
                    case 5:
                        // baseMessage = 'voice message'
                        $replyData->baseMessage =  'voice message';
                        break;
                    case 6:
                        // baseMessage = 'voice message'
                        $replyData->baseMessage =  'this message deleted... ';
                        break;
                }
            }
            $messageData->data = $replyData;
            break;
        case 5:
            // voice voiceUrl = 5
            $messageData->data = $row["voiceUrl"];
            break;
        case 6:
            // message deleted = 6
            $messageData->data = $row["messageText"];
            break;
    }

    return $messageData;
}
function getExpirePlan($planId, $planType, $clientId)
{
    global $connect;
    $nowDateTimeToExpire = time();
    $query = "";
    $expire = 1;
    if ($planType == "workout") {
        $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM tbl_started_plan WHERE planType = 0 AND plansId = '$planId' AND clientId = '$clientId' AND todayDateTraingingSec IS NOT NULL) + (((SELECT workOutPlanDuration FROM tbl_plans WHERE id = '$planId') * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire";
    } else if ($planType == "nutrition") {
        $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM tbl_started_plan WHERE planType = 1 AND plansId = '$planId' AND clientId = '$clientId' AND todayDateTraingingSec IS NOT NULL) + (((SELECT nutritionPlanDuration FROM tbl_plans WHERE id = '$planId') * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire";
    }
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $expire = $row['expire'];
    }
    return $expire;
}
function getChatListByClient($clientId, $searchText, $Page)
{
    global $connect;
    $pagingItem = PAGING_ITEM;
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    $query = "SELECT 
                p.clientId,
                p.profileName,
                p.profileEmail,
                p.profileImage,
                CASE
                	WHEN messageType = 1 THEN 'plan type'
                    WHEN messageType = 2 THEN 'photo message'
                    WHEN messageType = 3 THEN messageText
                    WHEN messageType = 4 THEN 'reply message'
                    WHEN messageType = 5 THEN 'voice message'
                    ELSE 'deleted message...'
                END AS messageText,
				m.messageType,
                DATE_FORMAT(m.insertDate, '%H:%i') AS insertTime,
                p.writerType,
                COALESCE(unseen.unseenCount, 0) AS unseenCount
            FROM (
                SELECT 
                    CASE 
                        WHEN t_chat.sender_id = '$clientId' THEN t_chat.receiver_id 
                        ELSE t_chat.sender_id 
                    END AS clientId,
                    CASE 
                        WHEN t_chat.sender_id = '$clientId' THEN  t_clientReceiver.email
                        ELSE t_clientSender.email
                    END AS profileEmail,
                    CASE 
                        WHEN t_chat.sender_id = '$clientId' THEN CONCAT(t_ctr.firstName, ' ', t_ctr.lastName)
                        ELSE CONCAT(t_cts.firstName, ' ', t_cts.lastName)
                    END AS profileName,
                    CASE 
                        WHEN t_chat.sender_id = '$clientId' THEN t_ctr.profileImage
                        ELSE t_cts.profileImage
                    END AS profileImage,
                    CASE 
                        WHEN t_chat.writerType = 0 THEN 'coach'
                        WHEN t_chat.writerType = 1 THEN 'athlete'
                        ELSE 'adminBodyBuilder'
                    END AS writerType,
                    MAX(t_chat.id) AS latestMessageId
                FROM tbl_chat AS t_chat 
                JOIN tbl_client AS t_clientSender ON t_chat.sender_id = t_clientSender.id 
                JOIN tbl_client_type AS t_cts ON t_clientSender.id = t_cts.client_id 
                JOIN tbl_client AS t_clientReceiver ON t_chat.receiver_id = t_clientReceiver.id 
                JOIN tbl_client_type AS t_ctr ON t_clientReceiver.id = t_ctr.client_id 
                WHERE t_chat.sender_id = '$clientId' OR t_chat.receiver_id = '$clientId' 
                GROUP BY clientId, profileName, profileImage
            ) AS p
            JOIN tbl_chat AS m ON m.id = p.latestMessageId
            LEFT JOIN (
                SELECT sender_id, COUNT(*) AS unseenCount
                FROM tbl_chat
                WHERE receiver_id = '$clientId' AND seen = 0
                GROUP BY sender_id
            ) AS unseen ON unseen.sender_id = p.clientId
            WHERE p.profileName LIKE '%$searchText%'
            ORDER BY m.insertDateSec DESC 
            LIMIT $page, $pagingItem;
        ";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["chats" => $row];

        Response::respondAndDieFun($data,  'tnx, send request plan');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function getMessageDataReplied($myId, $reciverId, $messageId, $lastMessageId)
{

    global $connect;
    $reciverId = checkSqlInjection($reciverId);
    $messageId = checkSqlInjection($messageId);
    $lastMessageId = checkSqlInjection($lastMessageId);

    $query = "SELECT 
            t_chat.id AS messageId,
            t_chat.writerType AS writerType,
            t_chat.sender_id AS senderId,
            t_chat.receiver_id AS receiverId,
            CONCAT(t_ct.firstName, ' ', t_ct.lastName) AS senderName,
            t_chat.messageType AS messageType,
            t_chat.messageText AS messageText,
            t_chat.tblPlanId AS tblPlanId,
            t_chat.photoUrl AS photoUrl,
            t_chat.replyToMessageId AS replyToMessageId,
            t_chat.voiceUrl AS voiceUrl,
            DATE_FORMAT(t_chat.insertDate, '%Y-%m-%d %H:%i:%s') AS messageDate,
            t_chat.insertDateSec AS timestamp,
            t_chat.seen AS isSeen,
            CASE 
                WHEN t_chat.sender_id = $myId THEN 1
                ELSE 0
            END AS isSender
        FROM 
            tbl_chat AS t_chat
        JOIN 
            tbl_client_type AS t_ct ON t_chat.sender_id = t_ct.client_id
        WHERE 
            (t_chat.sender_id = $myId AND t_chat.receiver_id = $reciverId)
            OR 
            (t_chat.sender_id = $reciverId AND t_chat.receiver_id = $myId)
        ORDER BY 
            t_chat.id DESC";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetchAll(PDO::FETCH_ASSOC);
        for ($i = 0; $i < sizeof($rows); $i++) {
            $row = $rows[$i];
            $messageData = _getDataMessageType($myId, $row);
            $rows[$i]["messageData"] = $messageData;
        }

        $data = ["messages" => $rows];
        Response::respondAndDieFun($data,  'get successfully message');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function getRequestDetails($requestId)
{

    global $connect;

    $query = "SELECT t_request.id, t_clientType.profileImage, t_request.coachId, t_request.clientId, CONCAT(t_request.firstName,' ',t_request.lastName) AS athleteName, t_request.email, t_request.age, t_request.country, t_request.city, t_request.gender, t_request.weight, t_request.height, t_request.waist, t_request.hip, t_request.arm, t_request.sportDiscipline, t_request.experience, t_request.perWeekExercise, t_request.previousMedicalConditions, t_request.detailPreviousConditions, t_request.currentlyMedication, t_request.detailCurrentlyConditions, t_request.bodyPhoto, t_request.requestDate, t_request.requestDateSec, t_request.acceptCoach, t_request.planId FROM tbl_request_plan AS t_request JOIN tbl_client_type AS t_clientType ON t_request.clientId = t_clientType.client_id WHERE t_request.id = '$requestId' ";


    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetch(PDO::FETCH_ASSOC);
        $data = ["details" => $rows];
        Response::respondAndDieFun($data,  'get successfully message');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function requestPlanByAthlete($data, $clientId)
{
    $insertedId = saveRequestPlan($data, $clientId, $data->coachId);
    if ($insertedId > 0) {
        $coachId = $data->coachId;
        global $connect;
        $query = "UPDATE tbl_request_plan SET expired='1' WHERE coachId = '$coachId' AND clientId = '$clientId' AND id != '$insertedId';";

        $res = $connect->prepare($query);
        $res->execute();
        Response::respondAndDieFun('',  'tnx, send request plan');
    } else {
        Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
    }
}
function saveRequestPlan($data, $clientId, $coachId)
{
    $requestId = 0;
    global $connect;

    $firstName = checkSqlInjection($data->firstName);
    $lastName = checkSqlInjection($data->lastName);
    $email = checkSqlInjection($data->email);
    $age = checkSqlInjection($data->age);
    $country = checkSqlInjection($data->country);
    $city = checkSqlInjection($data->city);
    $gender = checkSqlInjection($data->gender);
    $weight = checkSqlInjection($data->weight);
    $height = checkSqlInjection($data->height);
    $waist = checkSqlInjection($data->waist);
    $hip = checkSqlInjection($data->hip);
    $arm = checkSqlInjection($data->arm);
    $sportDiscipline = checkSqlInjection($data->sportDiscipline);
    $experience = checkSqlInjection($data->experience);
    $perWeekExercise = checkSqlInjection($data->perWeekExercise);
    $previousMedicalConditions = checkSqlInjection($data->previousMedicalConditions);
    $detailPreviousConditions = checkSqlInjection($data->detailPreviousConditions);
    $currentlyMedication = checkSqlInjection($data->currentlyMedication);
    $detailCurrentlyConditions = checkSqlInjection($data->detailCurrentlyConditions);
    $bodyPhoto = checkSqlInjection($data->bodyPhoto);
    $coachId = checkSqlInjection($data->coachId);
    $requestDate = getMyDateTimeNow();
    $requestDateSec = time();
    
    // $filePath = __DIR__ . '/debug_perWeekExercise.txt';
    // $logMessage = "Date: " . date('Y-m-d H:i:s') . " - perWeekExercise: $perWeekExercise\n";
    // file_put_contents($filePath, $logMessage, FILE_APPEND); // اضافه کردن به انتهای فایل
    
    
    $query = "INSERT INTO `tbl_request_plan`(`coachId`, `clientId`, `firstName`, `lastName`, `email`, `age`, `country`, `city`, `gender`, `weight`, `height`, `waist`, `hip`, `arm`, `sportDiscipline`, `experience`, `perWeekExercise`, `previousMedicalConditions`, `detailPreviousConditions`, `currentlyMedication`, `detailCurrentlyConditions`, `bodyPhoto`, `requestDate`, `requestDateSec`, `expired`)
                                     VALUES ('$coachId', '$clientId', '$firstName', '$lastName', '$email', '$age', '$country', '$city', '$gender', '$weight', '$height', '$waist', '$hip', '$arm', '$sportDiscipline', '$experience', '$perWeekExercise', '$previousMedicalConditions', '$detailPreviousConditions', '$currentlyMedication', '$detailCurrentlyConditions', '$bodyPhoto', '$requestDate', '$requestDateSec', '0')";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $requestId = $connect->lastInsertId();
    }
    return $requestId;
}
function sendPlanByCoach($data, $clientIdCoach)
{
    $athleteData = $data->AthleteData;
    $clientAthleteId = getClientIdByEmail($athleteData->email);
    if ($clientAthleteId > 0) {
        $requestIdInserted = saveRequestPlan($athleteData, $clientAthleteId, $clientIdCoach);

        if ($requestIdInserted > 0) {
            $plansData = $data->PlansData;
            $plansData->requestId = $requestIdInserted;
            $plansData->athleteId = $clientAthleteId;
            answerToRequestPlan($plansData, $clientIdCoach);
        } else {
            Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'email not found!', Response::HTTP_NOT_FOUND);
    }
}
function answerToRequestPlan($data, $clientIdCoach)
{
    global $connect;
    $requestId = checkSqlInjection($data->requestId);
    $answerCoach = checkSqlInjection($data->answerCoach);
    $answerCoachType = 0;

    if ($answerCoach == 'decline') {
        $answerCoachType = 0;
        $query = "UPDATE `tbl_request_plan` SET `acceptCoach`='$answerCoachType' WHERE id = '$requestId'";
        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            Response::respondAndDieFun('',  'tnx, save your answer');
        } else {
            Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
        }
    } else if ($answerCoach == 'accept') {
        $answerCoachType = 1;
        $haveWorkOutPlan = checkSqlInjection($data->HaveWorkOutPlan);
        $haveNutritionPlan = checkSqlInjection($data->HaveNutritionPlan);

        $dateTimeNow = getMyDateTimeNow();
        $dateTimeNowSec = time();

        $queryPlan = "INSERT INTO `tbl_plans`(`clientId`, `createDate`, `createDateSec`) VALUES ('$clientIdCoach','$dateTimeNow','$dateTimeNowSec')";
        $resPlan = $connect->prepare($queryPlan);
        $resPlan->execute();
        if ($resPlan->rowCount() > 0) {
            $planId = $connect->lastInsertId();

            $queryPlan = "UPDATE `tbl_request_plan` SET `acceptCoach`='1',`planId`='$planId' WHERE id = '$requestId' ";
            $resPlan = $connect->prepare($queryPlan);
            $resPlan->execute();

            $insertedPlanWorkOut = 0;
            $insertedPlanNutrition = 0;
            $planNameWorkOut = null;
            $planNameNutrition = null;
            if ($haveWorkOutPlan == 1) {
                $detailsWorkOutPlan = $data->DetailsWorkOutPlan;
                $planNameWorkOut = $detailsWorkOutPlan->planName;
                $insertedPlanWorkOut = storePlanWorkout($detailsWorkOutPlan, $planId, $clientIdCoach);
            }
            if ($haveNutritionPlan == 1) {
                $detailsNutritionPlan = $data->DetailsNutritionPlan;
                $planNameNutrition = $detailsNutritionPlan->planName;
                $insertedPlanNutrition = storePlanNutrition($detailsNutritionPlan, $planId, $clientIdCoach);
            }

            if ($insertedPlanWorkOut > 0 || $insertedPlanNutrition > 0) {
                $athleteId = checkSqlInjection($data->athleteId);

                //  writerType = 2 => adminBodyBuilder
                //  messageType = 0 => notifAdmin        
                $queryPlan = "INSERT INTO `tbl_chat`(`writerType`, `sender_id`, `receiver_id`, `messageType`, `messageText`, `insertDate`, `insertDateSec`) VALUES ('2','$clientIdCoach','$athleteId','0','Your plan has been created','$dateTimeNow','$dateTimeNowSec' )";
                $resPlan = $connect->prepare($queryPlan);
                $resPlan->execute();

                                //  writerType = 0 => coach
                //  messageType = 1 => plan
                $queryPlan = "INSERT INTO `tbl_chat`(`writerType`, `sender_id`, `receiver_id`, `messageType`, `tblPlanId`, `insertDate`, `insertDateSec`) VALUES ('0','$clientIdCoach','$athleteId','1','$planId','$dateTimeNow','$dateTimeNowSec' )";
                $resPlan = $connect->prepare($queryPlan);
                $resPlan->execute();

                $queryCoachName = "SELECT `firstName`, `lastName` From tbl_client_type WHERE client_id = '$clientIdCoach' ";
                $resCoachName = $connect->prepare($queryCoachName);
                $resCoachName->execute();
                if ($resCoachName->rowCount() > 0) {
                    $row = $resCoachName->fetch(PDO::FETCH_ASSOC);
                    $coachName = $row['firstName'] . ' ' . $row['lastName'];

                    $dataResponse = new stdClass();
                    if ($planNameWorkOut != null && $planNameNutrition != null) {
                        $dataResponse->planName =  $planNameWorkOut . ' - ' . $planNameNutrition;
                    } else if ($planNameNutrition != null) {
                        $dataResponse->planName = $planNameNutrition;
                    } else if ($planNameWorkOut != null) {
                        $dataResponse->planName = $planNameWorkOut;
                    }
                    $dataResponse->coachName = $coachName;
                    $dataResponse->creationDate = $dateTimeNow;

                    $queryCoachName = "SELECT `email` From tbl_client WHERE id = '$athleteId' ";
                    $resCoachName = $connect->prepare($queryCoachName);
                    $resCoachName->execute();
                    if ($resCoachName->rowCount() > 0) {
                        $row = $resCoachName->fetch(PDO::FETCH_ASSOC);

                        $dataResponse->ReceiverEmail = $row['email'];
                        Response::respondAndDieFun($dataResponse,  'tnx, send your plan');
                    }
                } else {
                    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
                }
            }
        }
    }
}

function storePlanWorkout($data, $planId, $clientIdCoach)
{
    $insertedPlan = 0;
    global $connect;

    $trainingListInDay = $data->trainingListInDay;
    for ($i = 0; $i < sizeof($trainingListInDay); $i++) {
        $selectedDayNumber = checkSqlInjection($trainingListInDay[$i]->selectedDayNumber);
        $selectedDayName = checkSqlInjection($trainingListInDay[$i]->selectedDayName);
        $detailsNumberDay = $trainingListInDay[$i]->detailsNumberDay;

        if (sizeof($detailsNumberDay) > 0) {
            for ($j = 0; $j < sizeof($detailsNumberDay); $j++) {
                // $selectedSubDictionaryId = $detailsNumberDay[$j]->selectedSubDictionaryId;
                // $selectedSubDictionaryId = implode(',', $detailsNumberDay[$j]->selectedSubDictionaryId);
                $selectedSubDictionaryId = json_encode([$detailsNumberDay[$j]->selectedSubDictionaryId]);

                $setTraining = checkSqlInjection($detailsNumberDay[$j]->setTraining);
                $repetitions = checkSqlInjection($detailsNumberDay[$j]->repetitions);
                $time = checkSqlInjection($detailsNumberDay[$j]->time);
                $rest = checkSqlInjection($detailsNumberDay[$j]->rest);
                $restBetweenSet = checkSqlInjection($detailsNumberDay[$j]->restBetweenSet);
                $weight = checkSqlInjection($detailsNumberDay[$j]->weight);
                $totalTime = checkSqlInjection($detailsNumberDay[$j]->totalTime);

                $queryPlanDetails = "INSERT INTO `tbl_plan_workout`(`tblPlansId`, `selectedSubDictionaryId`, `selectedDayNumber`, `selectedDayName`, `setTraining`, `repetitions`, `time`, `rest`, `restBetweenSet`, `weight`, `totalTime`) 
                                                                        VALUES ('$planId','$selectedSubDictionaryId','$selectedDayNumber','$selectedDayName','$setTraining','$repetitions','$time','$rest','$restBetweenSet','$weight','$totalTime')";

                $resPlanDetails = $connect->prepare($queryPlanDetails);
                $resPlanDetails->execute();
                if ($resPlanDetails->rowCount() > 0) {
                    $insertedPlan += 1;
                }
            }

            $planName = checkSqlInjection($data->planName);
            $trainingDays = json_encode($data->trainingDays);

            $planDuration = checkSqlInjection($data->planDuration);

            $queryPlan = "UPDATE `tbl_plans` SET `clientId`='$clientIdCoach',`haveWorkOutPlan`='1',`workOutName`=' $planName',`workOutTrainingDays`='$trainingDays',`workOutPlanDuration`='$planDuration' WHERE id = '$planId' ";
            $resPlan = $connect->prepare($queryPlan);
            $resPlan->execute();
        }
    }
    return $insertedPlan;
}
function storePlanNutrition($data, $planId, $clientIdCoach)
{
    $insertedPlan = 0;

    global $connect;

    $planName = checkSqlInjection($data->planName);
    $trainingDays = json_encode($data->trainingDays);

    $planDuration = checkSqlInjection($data->planDuration);

    $nutritionListInDay = $data->nutritionListInDay;
    // $nutritionListInDay = json_encode($data->nutritionListInDay);

    for ($i = 0; $i < sizeof($nutritionListInDay); $i++) {
        $selectedDayNumber = $nutritionListInDay[$i]->day;
        $meals = $nutritionListInDay[$i]->mealName;
        $foodNames = $nutritionListInDay[$i]->foods;

        if (sizeof($foodNames) > 0) {
            for ($j = 0; $j < sizeof($foodNames); $j++) {
                $foodName = checkSqlInjection($foodNames[$j]);

                $queryPlanDetails = "INSERT INTO `tbl_plan_nutrition`(`tblPlansId`, `selectedDayNumber`, `mealName`, `foodName`) 
                                                                  VALUES ('$planId','$selectedDayNumber','$meals','$foodName' )";

                $resPlanDetails = $connect->prepare($queryPlanDetails);
                $resPlanDetails->execute();
                if ($resPlanDetails->rowCount() > 0) {
                    $insertedPlan += 1;
                }
            }
            $planName = checkSqlInjection($data->planName);
            $trainingDays = json_encode($data->trainingDays);

            $planDuration = checkSqlInjection($data->planDuration);

            $queryPlan = "UPDATE `tbl_plans` SET `clientId`='$clientIdCoach',`haveNutritionPlan`='1',`nutritionName`=' $planName',`nutritionTrainingDays`='$trainingDays',`nutritionPlanDuration`='$planDuration' WHERE id = '$planId' ";
            $resPlan = $connect->prepare($queryPlan);
            $resPlan->execute();
        }
    }
    return $insertedPlan;
}

function getClientIdByEmail($email)
{
    global $connect;
    $clientId = 0;
    $queryCoachName = "SELECT `id` From tbl_client WHERE email = '$email' ";
    $resCoachName = $connect->prepare($queryCoachName);
    $resCoachName->execute();
    if ($resCoachName->rowCount() > 0) {
        $row = $resCoachName->fetch(PDO::FETCH_ASSOC);
        $clientId = $row['id'];
    }
    return  $clientId;
}

function savedPlan($data, $clientId)
{
    global $connect;

    $planId = checkSqlInjection($data->planId);
    $planType = checkSqlInjection($data->planType);
    $insertDate = getMyDateTimeNow();
    $insertDateSec = time();

    $query = "INSERT INTO `tbl_saved_plan`(`plansId`, `clientId`, `planType`, `insertDate`, `insertDateSec`) VALUES ('$planId','$clientId','$$planType','$insertDate','$insertDateSec')";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        saveStart($data, $clientId);
        Response::respondAndDieFun('',  'save your plan');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}

function saveStart($data, $clientId)
{
    global $connect;
    $rowId = 0;
    $planId = checkSqlInjection($data->planId);
    $planType = checkSqlInjection($data->planType);

    $query = "INSERT INTO `tbl_started_plan`(`plansId`, `clientId`, `planType`) VALUES ('$planId','$clientId','$planType')";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rowId = $connect->lastInsertId();
    }
    return  $rowId;
}
function saveToStartPlan($data, $clientId)
{
    if (saveStart($data, $clientId) > 0) {
        Response::respondAndDieFun('',  'save your plan to start');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function uploadPhoto($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = __DIR__ . '/../../uploads/chat_photo/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
        $uploadDir=UPLOAD_DIR;
        $fileUrl = $uploadDir . 'chat_photo/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadPhoto($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/chat_photo/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/chat_photo/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfuly upload file');
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }
function uploadVoice($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = __DIR__ . '/../../uploads/chat_voice/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
        $uploadDir=UPLOAD_DIR;
        $fileUrl = $uploadDir . 'chat_voice/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadVoice($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/chat_voice/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/chat_voice/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfully upload file');
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }
function seenAllMessage($data, $clientId)
{
    global $connect;

    $senderId = checkSqlInjection($data->senderId);

    $query = "UPDATE `tbl_chat` SET `seen`='1' WHERE sender_id = '$senderId' AND receiver_id = '$clientId'";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        Response::respondAndDieFun('',  'save to seen messages');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}

function seenRequest($data)
{
    global $connect;
    $requestId = checkSqlInjection($data->REQUEST_ID);

    $query = "UPDATE `tbl_request_plan` SET `seen` = '1' WHERE `id` = '$requestId'";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        Response::respondAndDieFun('',  'tnx, save your answer');
    } else {
        Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
    }
}

function responseToRequestPlan($coachId, $data)
{
    global $connect;
    $requestId = checkSqlInjection($data->REQUEST_ID);
    $response = checkSqlInjection($data->RESPONSE);
    $receiverId = checkSqlInjection($data->CLIENT_ID);

    $query = "UPDATE `tbl_request_plan` SET `acceptCoach` = '$response' WHERE `id` = '$requestId'";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        if ($response == 1) {
            $insertDate = getMyDateTimeNow();
            $insertDateSec = time();
            $query = "INSERT INTO `tbl_chat`( `writerType`, `sender_id`, `receiver_id`, `messageType`, `messageText`,`insertDate`, `insertDateSec`)
             VALUES ('2','$coachId','$receiverId','0','Your plan request has been accept','$insertDate','$insertDateSec')";
            $res = $connect->prepare($query);
            $res->execute();
        }
        Response::respondAndDieFun('',  'tnx, save your answer');
    } else {
        Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
    }
}
