<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;

function getCoachListDefault($Page, $SearchItem)
{

    $page = checkSqlInjection($Page);
    $page = checkSqlInjection($Page);
    $pagingItem = PAGING_ITEM;

    $query = '';

    global $connect;
    $query = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.gender AS gender, t_coach.yearsExperience AS experience, t_coach.sportDescipline AS sportDescipline, t_coach.typeService AS plan, t_coach.feeAmount AS feeAmount, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_coaching_team AS t_coach JOIN tbl_client_type AS t_client ON t_coach.clientId = t_client.client_id WHERE CONCAT(t_coach.firstName,' ',t_coach.lastName) LIKE '%$SearchItem%' ORDER BY rate DESC LIMIT $page,$pagingItem;";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetchAll(PDO::FETCH_ASSOC);

        for ($i = 0; $i < sizeof($rows); $i++) {
            $rows[$i]['plan'] = fixDoubleEncodedJson($rows[$i]['plan']);
        }

        $data = ["coachs" => $rows];
        Response::respondAndDieFun($data,  'successfuly get coach');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function getCoachListFilter($clientId, $gender, $sortedBy, $specializedField, $plan, $experience, $Page)
{

    $gender = checkSqlInjection($gender);
    $sortedBy = checkSqlInjection($sortedBy);
    $specializedField = checkSqlInjection($specializedField);
    $plan = checkSqlInjection($plan);
    $experience = checkSqlInjection($experience);
    $page = checkSqlInjection($Page);
    $pagingItem = PAGING_ITEM;

    $query = '';

    global $connect;
    if ($sortedBy == 'cheapest') {
        $query = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.gender AS gender, t_coach.yearsExperience AS experience, t_coach.sportDescipline AS sportDescipline, t_coach.typeService AS plan, t_coach.feeAmount AS feeAmount, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_coaching_team AS t_coach JOIN tbl_client_type AS t_client ON t_coach.clientId = t_client.client_id WHERE t_coach.gender = '$gender' AND t_coach.sportDescipline LIKE '%$specializedField%' AND t_coach.typeService LIKE '%$plan%' AND t_coach.yearsExperience = '$experience' ORDER BY feeAmount ASC LIMIT $page,$pagingItem;";
    } else if ($sortedBy == 'expensive') {
        $query = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.gender AS gender, t_coach.yearsExperience AS experience, t_coach.sportDescipline AS sportDescipline, t_coach.typeService AS plan, t_coach.feeAmount AS feeAmount, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_coaching_team AS t_coach JOIN tbl_client_type AS t_client ON t_coach.clientId = t_client.client_id WHERE t_coach.gender = '$gender' AND t_coach.sportDescipline LIKE '%$specializedField%' AND t_coach.typeService LIKE '%$plan%' AND t_coach.yearsExperience = '$experience' ORDER BY feeAmount DESC LIMIT $page,$pagingItem;";
    } else if ($sortedBy == 'saved') {
        $query = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.gender AS gender, t_coach.yearsExperience AS experience, t_coach.sportDescipline AS sportDescipline, t_coach.typeService AS plan, t_coach.feeAmount AS feeAmount, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_coaching_team AS t_coach JOIN tbl_client_type AS t_client ON t_coach.clientId = t_client.client_id JOIN tbl_saved_coach AS t_saved ON t_saved.coachId = t_coach.id WHERE t_saved.clientId = '$clientId' AND t_coach.gender = '$gender' AND t_coach.sportDescipline LIKE '%$specializedField%' AND t_coach.typeService LIKE '%$plan%' AND t_coach.yearsExperience = '$experience' ORDER BY t_saved.id DESC LIMIT $page,$pagingItem;";
    }

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rows = $res->fetchAll(PDO::FETCH_ASSOC);

        for ($i = 0; $i < sizeof($rows); $i++) {
            $rows[$i]['plan'] = fixDoubleEncodedJson($rows[$i]['plan']);
        }

        $data = ["coachs" => $rows];
        Response::respondAndDieFun($data,  'successfuly get coach');
    }
    Response::respondAndDieFun('',  'not found', Response::HTTP_NOT_FOUND);
}

function getReview($clientId, $Page)
{

    $page = checkSqlInjection($Page);
    $clientId = checkSqlInjection($clientId);
    $pagingItem = PAGING_ITEM;

    $query = '';

    global $connect;
    $query = "SELECT CONCAT(t_client.firstName,' ',t_client.lastName) AS profileName, t_client.profileImage AS profileImage, DATE_FORMAT(t_rate.insertDate, '%Y-%m-%d') AS insertDate, t_rate.rate AS rate, t_rate.comment AS comment FROM tbl_rate AS t_rate JOIN tbl_client_type AS t_client ON t_rate.voterId = t_client.client_id WHERE t_rate.clientId = '$clientId' ORDER BY t_rate.insertDate DESC LIMIT $page,$pagingItem;";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $rowReview = $res->fetchAll(PDO::FETCH_ASSOC);

        $queryCount = "SELECT SUM(`rate`) AS rate, COUNT(*) AS reviewCount FROM `tbl_rate` WHERE `clientId` = '$clientId'";
        $resCount = $connect->prepare($queryCount);
        $resCount->execute();
        if ($resCount->rowCount() > 0) {
            $rowCount = $resCount->fetch(PDO::FETCH_ASSOC);
            $rate = $rowCount['rate'];
            $reviewCount = $rowCount['reviewCount'];
            $data = new stdClass();
            $data->rate = $rate;
            $data->reviewCount = $reviewCount;
            $data->reviews = $rowReview;
            Response::respondAndDieFun($data,  'successfuly get review');
        }
    }
    Response::respondAndDieFun('',  'not found', Response::HTTP_NOT_FOUND);
}
function getAboutCoach($coachId)
{
    $coachId = checkSqlInjection($coachId);

    global $connect;
    $query = "SELECT t_coach.id AS coachId, t_client.profileImage AS profileImage, t_client.firstName AS firstName, t_client.lastName AS lastName, t_coach.gender AS gender, t_coach.sportDescipline AS sportDescipline, t_coach.yearsExperience AS yearsExperience, t_coach.typeService AS typeService, t_coach.feeAmount AS feeAmount FROM tbl_coaching_team AS t_coach JOIN tbl_client_type AS t_client ON t_coach.clientId = t_client.client_id WHERE t_coach.id = '$coachId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $row['typeService'] = fixDoubleEncodedJson($row['typeService']);

        Response::respondAndDieFun($row,  'successfuly get about coach');
    }
    Response::respondAndDieFun('',  'not found', Response::HTTP_NOT_FOUND);
}
function getAllowSendRequestPlan($coachTeamId, $clientId)
{
    // این تابع برای جلوگیری از ارسال درخواست‌های تکراری در بازه زمانی کوتاه(24 ساعت) طراحی شده است.

    $coachId = checkSqlInjection($coachTeamId);
    $allowSendRequest = 1;
    try {
        global $connect;
        $query = "SELECT `id`,`acceptCoach`, `planId` FROM `tbl_request_plan` WHERE `coachId` = '$coachId' AND `clientId` = '$clientId' AND `requestDateSec` <= (`requestDateSec` + 86400) ORDER BY `requestDateSec` DESC LIMIT 1 ;";
        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $acceptCoach = $row['acceptCoach'];
            $planId = $row['planId'];
            
            $decline = 0;
            $accept = 1;
            $waiting = 2;

            if ($acceptCoach == $decline) {
                $allowSendRequest = 1;
            } else if ($acceptCoach == $accept) {
                $allowSendRequest = 0;
            } else if ($acceptCoach == $waiting) {
                $allowSendRequest = 0;
            }
        }
        $data = ['allowSendRequest' => $allowSendRequest];
        Response::respondAndDieFun($data,  'successfuly get expire time plan to request new plan');
    } catch (\Throwable $th) {
        Response::respondAndDieFun($th,  'occured error', Response::HTTP_NOT_FOUND);
    }
}
function getHavePlanActivWithCoach($coachTeamId, $clientId)
{
    $coachId = checkSqlInjection($coachTeamId);
    $nowDateTime = time();
    $havePlanActive = 0;

    try {
        global $connect;
        $query = "SELECT `id`,`planId`,`requestDate` FROM `tbl_request_plan` WHERE `coachId` = '$coachId' AND `clientId` = '$clientId' AND `expired` = '0' AND `acceptCoach` = '1' AND `planId` > '0' ORDER BY `requestDate` DESC LIMIT 1;";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $requestId = $row['id'];
            $planId = $row['planId'];

            $queryPlan = "SELECT `haveWorkOutPlan`,`workOutPlanDuration`,`haveNutritionPlan`,`nutritionPlanDuration`,`createDateSec` FROM `tbl_plans` WHERE `id` = '$planId'";

            $resPlan = $connect->prepare($queryPlan);
            $resPlan->execute();
            if ($resPlan->rowCount() > 0) {
                $rowPlan = $resPlan->fetch(PDO::FETCH_ASSOC);
                $haveWorkOutPlan = $rowPlan['haveWorkOutPlan'];
                $workOutPlanDuration = $rowPlan['workOutPlanDuration'];
                $haveNutritionPlan = $rowPlan['haveNutritionPlan'];
                $nutritionPlanDuration = $rowPlan['nutritionPlanDuration'];
                $createDateSec = $rowPlan['createDateSec'];

                $nowDateTime = time();
                if ($haveWorkOutPlan = 1) {
                    $queryWorkOut = "SELECT `id`,`todayDateTraingingSec` FROM `tbl_started_plan` WHERE `plansId` = '$planId' AND `planType` = '0' AND `todayDateTraingingSec` > 0 ORDER BY `todayDateTraingingSec` ASC LIMIT 1";

                    $resWorkOut = $connect->prepare($queryWorkOut);
                    $resWorkOut->execute();
                    if ($resWorkOut->rowCount() > 0) {
                        $rowWorkout = $resWorkOut->fetch(PDO::FETCH_ASSOC);
                        $todayDateTraingingSec = $rowWorkout['todayDateTraingingSec'];

                        if (((($workOutPlanDuration * 7) * 86400) + $todayDateTraingingSec) >= $nowDateTime) {
                            $havePlanActive = 1;
                        }
                    }
                }
                if ($haveNutritionPlan = 1) {
                    $queryNutrition = "SELECT `id`,`todayDateTraingingSec` FROM `tbl_started_plan` WHERE `plansId` = '$planId' AND `planType` = '1' AND `todayDateTraingingSec` > 0 ORDER BY `todayDateTraingingSec` ASC LIMIT 1";

                    $resNutrition = $connect->prepare($queryNutrition);
                    $resNutrition->execute();
                    if ($resNutrition->rowCount() > 0) {
                        $rowNutrition = $resNutrition->fetch(PDO::FETCH_ASSOC);
                        $todayDateTraingingSec = $rowNutrition['todayDateTraingingSec'];

                        if (((($nutritionPlanDuration * 7) * 86400) + $todayDateTraingingSec) >= $nowDateTime) {
                            $havePlanActive = 1;
                        }
                    }
                }
            }
        }
        $data = ['havePlanActive' => $havePlanActive];

        Response::respondAndDieFun($data,  'successfuly get expire time plan request');
    } catch (\Throwable $th) {
        Response::respondAndDieFun('',  'error occured found', Response::HTTP_NOT_FOUND);
    }
}
function insertNewRate($data, $clientId)
{

    $coachClientId = checkSqlInjection($data->coachClientId);
    $rate = checkSqlInjection($data->rate);
    $comment = checkSqlInjection($data->comment);
    $insertDate = getMyDateTimeNow();
    $query = '';

    global $connect;
    $query = "SELECT * FROM `tbl_rate` WHERE `clientId` = '$coachClientId' AND `voterId` = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() == 0) {

        $queryRate = "INSERT INTO `tbl_rate`(`clientId`, `voterId`, `rate`, `comment`, `insertDate`) VALUES ('$coachClientId','$clientId','$rate','$comment','$insertDate')";
        $resCount = $connect->prepare($queryRate);
        $resCount->execute();
        if ($resCount->rowCount() > 0) {
            Response::respondAndDieFun('',  'successfuly insertrate');
        }
    }
    Response::respondAndDieFun('',  'you have already registered your rate for this coach ', Response::HTTP_NOT_FOUND);
}
function requestPlan($data, $clientId)
{
    $insertedId = saveRequestPlan($data, $clientId, $data->coachId);
    if ($insertedId > 0) {
        $coachId = $data->coachId;
        global $connect;
        $query = "UPDATE `tbl_request_plan` SET `expired`='1' WHERE `coachId` = '$coachId' AND `clientId` = '$clientId' AND `id` != '$insertedId';";

        $res = $connect->prepare($query);
        $res->execute();
        $test = ["id" => $insertedId];
        Response::respondAndDieFun($test,  'tnx, send request plan');
    } else {
        Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
    }
}
function saveCoach($data, $clientId)
{
    $coachId = checkSqlInjection($data->coachTeamId);

    global $connect;
    $query = "SELECT * FROM `tbl_saved_coach` WHERE `coachId` = '$coachId' AND `clientId` = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() == 0) {
        $query = "INSERT INTO `tbl_saved_coach`(`coachId`, `clientId`) VALUES ('$coachId','$clientId')";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            Response::respondAndDieFun('',  'successfuly saved coach');
        }
    } else {
        Response::respondAndDieFun('',  'this coach already saved', Response::HTTP_NOT_FOUND);
    }
}

function uploadBodyPhoto($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = __DIR__ . '/../../uploads/body_photo_request_plan/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
       $uploadDir=UPLOAD_DIR;
        $fileUrl = $uploadDir . 'body_photo_request_plan/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadBodyPhoto($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/body_photo_request_plan/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/body_photo_request_plan/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfully upload file'); // تصحیح املایی
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }