<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;

function getDailyActivitiesByDate($clientId,  $year, $month) {

    $clientId = (int)$clientId;
    // $fullDate = checkSqlInjection($fullDate);

    // $date = new DateTime($fullDate);
    // $year = $date->format('Y'); // 2025
    // $month = $date->format('m'); // 04 (با صفر پیش‌وند)

    global $connect;
    
    $query = "SELECT 
                DATE(`todayDateTrainging`) AS unique_day,
                MIN(`todayDateTraingingSec`) AS first_record_millisec
                FROM tbl_started_plan
                WHERE `clientId` = ? 
                AND DATE_FORMAT(`todayDateTrainging`, '%Y') = ? 
                AND DATE_FORMAT(`todayDateTrainging`, '%m') = ?
                GROUP BY unique_day
                ORDER BY unique_day;";

    $stmt = $connect->prepare($query);
    $stmt->execute([$clientId, $year, $month]);    

    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $data=["date"=>$row];
        Response::respondAndDieFun($data,  'Get activities date successful');
    } else {
        Response::respondAndDieFun('',  'Not found activities date', Response::HTTP_NOT_FOUND);
    }
}