<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;


function GetBanner($clientId)
{
    global $connect;
    $banner = [];
    $queryClient = "SELECT CONCAT_WS(' ',`firstName`,`lastName`) AS 'clientName' FROM `tbl_client_type` WHERE `client_id` = '$clientId'";
    $resClient = $connect->prepare($queryClient);
    $resClient->execute();
    if ($resClient->rowCount() > 0) {
        $rowClientName = $resClient->fetch(PDO::FETCH_ASSOC);
        $clientName = $rowClientName['clientName'];

        $query = "SELECT `id`, `itemName`, `imageItem` FROM `tbl_banner` WHERE `enable` = '1'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $banner = $res->fetchAll(PDO::FETCH_ASSOC);
        }
        $data = new stdClass();
        $data->banner = $banner;
        $data->clientName = $clientName;
        $data->timeOfDay =  getNotifHome();
        Response::respondAndDieFun($data,  'successfuly get banner');
    }

    Response::respondAndDieFun('',  'not found.', Response::HTTP_NOT_FOUND);
}
function getNotifHome($timestamp = null)
{
    // اگر timestamp مشخص نشده باشد از زمان فعلی استفاده می‌کند
    $hour = date('H', $timestamp ?? time());

    $times = [
        'night'    => ['Good night.', 23, 4],   // شب (11pm-4am)
        'morning'  => ['Good morning.', 5, 9],   // صبح (5am-9am)
        'midday'   => ['Good afternoon.', 10, 13], // ظهر (10am-1pm)
        'afternoon' => ['Good afternoon.', 14, 17], // بعدازظهر (2pm-5pm)
        'evening'  => ['Good evening.', 18, 22]  // عصر (6pm-10pm)
    ];

    foreach ($times as $period) {
        if ($hour >= $period[1] && $hour <= $period[2]) {
            return $period[0];
        }
    }

    return 'Good night'; // به عنوان مقدار پیش‌فرض
}
function getDefaultDictionary()
{

    // // // مسیر پوشه مورد نظر
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Biceps/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 1);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Chest/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 2);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Triceps/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 3);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Legs/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 4);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Lats/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 5);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Shoulders and Back/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 6);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Muscles/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 7);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Equipments/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 8);
    // $directory = 'C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Others/'; // مسیر کامل پوشه را وارد کنید
    // saveFileInfoToDatabase($directory, 10);


    global $connect;
    $query = "SELECT `id`,`categoryName`, `categoryItemIcon` FROM `tbl_dictionary` LIMIT 3";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["dictionary" => $row];
        Response::respondAndDieFun($data,  'successfuly get category dictionary');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
// تابع برای ذخیره اطلاعات فایل‌ها در دیتابیس
function saveFileInfoToDatabase($directory, $catNum)
{
    // http://192.168.236.13/Bodybuilder_php/Client/uploads/profile_images/59d49d4b782a90693319f93840749bfc.jpg
    // C:/xampp/htdocs/Bodybuilder_php/Client/uploads/dictionary/animation/720/Biceps/bde8952c29290f49.gif
    // بررسی وجود پوشه
    if (!is_dir($directory)) {
        die("پوشه مورد نظر یافت نشد!");
    }
    global $connect;
    // اسکن محتویات پوشه
    $files = scandir($directory);

    // حذف . و .. از لیست
    $files = array_diff($files, array('.', '..'));

    foreach ($files as $file) {
        $filePath = $directory . $file;
        // فقط فایل‌های معمولی را پردازش کن (نه پوشه‌ها)
        if (is_file($filePath)) {
            $fileName = pathinfo($file, PATHINFO_FILENAME); // نام فایل بدون پسوند
            $fileExt = pathinfo($file, PATHINFO_EXTENSION); // پسوند فایل
            // $fileAddress = $filePath; // آدرس کامل فایل

            $oldPath = $directory . $file;

            $fileDescription = str_replace(['-', '_'], ' ', $fileName);


            $newName = bin2hex(random_bytes(8)) . '.' . $fileExt;

            $newPath = $directory . $newName;

            if (rename($oldPath, $newPath)) {


                try {
                    // درج اطلاعات در دیتابیس
                    $query = "INSERT INTO `tbl_dictionary_sub`(`dictionaryId`, `animationUrl`, `description`)
                                                       VALUES ('$catNum','$newPath','$fileDescription')";

                    $res = $connect->prepare($query);
                    $res->execute();


                    echo "فایل $newPath با موفقیت ذخیره شد.<br>";
                    echo "فایل $fileDescription با موفقیت ذخیره شد.<br>";
                    echo "===============================<br>";
                } catch (PDOException $e) {
                    echo "خطا در ذخیره فایل $file: " . $e->getMessage() . "<br>";
                }
            }
        }
    }
}
function sanitizeFilename($filename)
{
    // حذف کاراکترهای غیرمجاز
    $clean = preg_replace('/[^\w\-\.\p{L}\s]/u', '', $filename);

    // جایگزینی فاصله و خط تیره با زیرخط
    $clean = preg_replace('/[\s\-]+/', '_', $clean);

    // حذف زیرخط‌های تکراری
    $clean = preg_replace('/_+/', '_', $clean);

    // حذف زیرخط از ابتدا و انتها
    $clean = trim($clean, '_');

    // تبدیل به حروف کوچک (اختیاری)
    $clean = mb_strtolower($clean, 'UTF-8');

    return $clean;
}

function geCategoryDictionary($searchText, $Page)
{
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    $pageItem = PAGING_ITEM;
    global $connect;
    $query = "SELECT `id`,`categoryName`, `categoryItemIcon` FROM `tbl_dictionary` WHERE categoryName LIKE '%$searchText%' AND `enable` = '1' LIMIT $page,$pageItem";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["dictionary" => $row];
        Response::respondAndDieFun($data,  'successfuly get category dictionary');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function geSubDictionary($searchText, $categoryId, $Page)
{
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    $pageItem = PAGING_ITEM;
    global $connect;
    $query = "SELECT `id`, `dictionaryId`, `animationUrl`, `description` FROM `tbl_dictionary_sub` WHERE `dictionaryId` = '$categoryId' AND CONCAT(' ', `animationUrl`,`description`) LIKE '%$searchText%' AND `enable` = '1' LIMIT $page,$pageItem";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["dictionary" => $row];

        Response::respondAndDieFun($data,  'successfuly get sub dictionary');
    }
    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
function getWotkoutPlanSaved($clientId)
{
    global $connect;
    $nowDateTimeToExpire = time();
    // planType=0 =>workoutPlan
    $planType = 0;

    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, CONCAT_WS(' ',t_client.firstName,t_client.lastName) AS coachName,  'workOut' AS 'planType', t_sPlan.plansId AS planId, t_plan.workOutName planName, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND  `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id  JOIN tbl_client_type AS t_client ON t_sPlan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' AND t_plan.haveWorkOutPlan = 1  AND t_sPlan.planType = '$planType' ORDER BY t_splan.insertDateSec DESC LIMIT 3";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["plans" => $row];
        Response::respondAndDieFun($data,  'successfuly get workout plans');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}
function getWorkoutPlanSavedSingle($clientId,$planId)
{
    global $connect;
    $nowDateTimeToExpire = time();
    // planType=0 =>workoutPlan
    $planType = 0;

    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, CONCAT_WS(' ',t_client.firstName,t_client.lastName) AS coachName,  'workOut' AS 'planType', t_sPlan.plansId AS planId, t_plan.workOutName planName, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND  `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, t_plan.clientId AS coachId FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id  JOIN tbl_client_type AS t_client ON t_sPlan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' AND t_plan.haveWorkOutPlan = 1  AND t_sPlan.planType = '$planType' AND t_plan.id = '$planId'";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $data = ["planData" => $row];
        Response::respondAndDieFun($data,  'successfuly get workout single plan');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}
function getAllWotkoutPlanSaved($clientId, $searchText, $Page)
{
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    $pageItem = PAGING_ITEM;
    $nowDateTimeToExpire = time();
    // planType=0 =>workoutPlan
    $planType = 0;

    global $connect;
    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_sPlan.plansId AS planId, t_plan.workOutName AS planName, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND  `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_plan.createDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE CONCAT(t_plan.workOutName,t_client.firstName,t_client.lastName,' ') LIKE '%$searchText%' AND t_sPlan.clientId = '$clientId' AND t_plan.haveWorkOutPlan = 1  AND t_sPlan.planType = '$planType' ORDER BY t_splan.insertDateSec DESC LIMIT $page,$pageItem";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["plans" => $row];
        Response::respondAndDieFun($data,  'successfuly get workout plans');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}
function getNutritionPlanSaved($clientId)
{
    $nowDateTimeToExpire = time();
    // planType=1 =>nutritionPlan
    $planType = 1;

    global $connect;
    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, CONCAT_WS(' ',t_client.firstName,t_client.lastName) AS coachName, 'nutrition' AS 'planType', t_sPlan.plansId AS planId, t_plan.nutritionName planName, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND  `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id  JOIN tbl_client_type AS t_client ON t_sPlan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' AND t_plan.haveNutritionPlan = 1  AND t_sPlan.planType = '$planType' ORDER BY t_splan.insertDateSec DESC LIMIT 3";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["plans" => $row];
        Response::respondAndDieFun($data,  'successfuly get nutrition plans');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}

function getNutritionPlanSavedSingle($clientId,$planId)
{
    global $connect;
    $nowDateTimeToExpire = time();
    // planType=0 =>nutritinPlan
    $planType = 1;

    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, CONCAT_WS(' ',t_client.firstName,t_client.lastName) AS coachName,  'nutrition' AS 'planType', t_sPlan.plansId AS planId, t_plan.nutritionName planName, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND  `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, t_plan.clientId AS coachId FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id  JOIN tbl_client_type AS t_client ON t_sPlan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' AND t_plan.haveNutritionPlan = 1  AND t_sPlan.planType = '$planType' AND t_plan.id = '$planId'";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $data = ["planData" => $row];
        Response::respondAndDieFun($data,  'successfuly get nutritin single plan');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}
function getAllNutritionPlanSaved($clientId, $searchText, $Page)
{
    $page = checkSqlInjection($Page);
    $searchText = checkSqlInjection($searchText);
    $pageItem = PAGING_ITEM;
    // planType=1 =>nutritionPlan
    $planType = 1;

    $nowDateTimeToExpire = time();
    global $connect;
    $query = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_sPlan.plansId AS planId, t_plan.nutritionName planName, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = '$planType' AND `plansId` = t_plan.id AND `clientId` = '$clientId' AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_plan.createDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE CONCAT(t_plan.nutritionName,t_client.firstName,t_client.lastName,' ') LIKE '%$searchText%' AND t_sPlan.clientId = '$clientId' AND t_plan.haveNutritionPlan = 1 AND t_sPlan.planType = '$planType' ORDER BY t_splan.insertDateSec DESC LIMIT $page,$pageItem";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["plans" => $row];
        Response::respondAndDieFun($data,  'successfuly get nutrition plans');
    }
    Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
}
function getWorkoutExcercise($planId, $selectedDayNumber)
{
    $planId = checkSqlInjection($planId);
    $selectedDayNumber = checkSqlInjection($selectedDayNumber);
    global $connect;

    $query = "SELECT `tblPlansId`, `selectedSubDictionaryId`, `selectedDayNumber`, 
                     `selectedDayName`, `setTraining`, `repetitions`, `time`, `rest`, 
                     `restBetweenSet`, `weight`, `totalTime` 
              FROM `tbl_plan_workout` 
              WHERE `tblPlansId` = :planId AND  `selectedDayNumber` = :selectedDayNumber ";

    $res = $connect->prepare($query);
    $res->bindParam(':planId', $planId, PDO::PARAM_INT);
    $res->bindParam(':selectedDayNumber', $selectedDayNumber, PDO::PARAM_INT);
    $res->execute();

    if ($res->rowCount() > 0) {
        $rows = $res->fetch(PDO::FETCH_ASSOC);

        // ابتدا همه dictionaryIdهای مورد نیاز را جمع آوری می‌کنیم
        $allDictIds = [];

        $subDictIds = json_decode($rows['selectedSubDictionaryId'], true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($subDictIds)) {
            foreach ($subDictIds as $idGroup) {
                if (is_array($idGroup)) {
                    $allDictIds = array_merge($allDictIds, $idGroup);
                } elseif (!empty($idGroup)) {
                    $allDictIds[] = $idGroup;
                }
            }
        }


        // همه اطلاعات dictionary را در یک کوئری دریافت می‌کنیم
        $dictData = [];
        if (!empty($allDictIds)) {
            $inQuery = implode(',', array_fill(0, count($allDictIds), '?'));
            $queryDict = "SELECT `id`, `animationUrl`, `description` 
                         FROM `tbl_dictionary_sub` 
                         WHERE `id` IN ($inQuery)";

            $resDict = $connect->prepare($queryDict);
            $resDict->execute($allDictIds);

            while ($item = $resDict->fetch(PDO::FETCH_ASSOC)) {
                $dictData[$item['id']] = [
                    'animationUrl' => $item['animationUrl'],
                    'description' => $item['description']
                ];
            }
        }

        // حالا داده‌های اصلی را پردازش می‌کنیم
        $subDictIds = json_decode($rows['selectedSubDictionaryId'], true);
        $processedItems = [];

        if (json_last_error() === JSON_ERROR_NONE && is_array($subDictIds)) {
            foreach ($subDictIds as $idGroup) {
                $groupItems = [];

                // تبدیل مقدار تکی به آرایه
                if (!is_array($idGroup)) {
                    $idGroup = !empty($idGroup) ? [$idGroup] : [];
                }

                foreach ($idGroup as $dictId) {
                    if (!empty($dictId) && isset($dictData[$dictId])) {
                        $dictItem = new stdClass();
                        $dictItem->animationUrl = $dictData[$dictId]['animationUrl'];
                        $dictItem->description = $dictData[$dictId]['description'];
                        $groupItems[] = $dictItem;
                    }
                }

                if (!empty($groupItems)) {
                    $processedItems[] = $groupItems;
                }
            }
        }

        $rows['selectedSubDictionaryId'] = $processedItems;


        $data = ["plan" => $rows];
        Response::respondAndDieFun($data, 'successfully get plan');
    }

    Response::respondAndDieFun('', 'not exist any plan', Response::HTTP_NOT_FOUND);
}
// function getPlanWorkout($planId)
// {
//     $planId = checkSqlInjection($planId);

//     global $connect;
//     $query = "SELECT `tblPlansId`, `selectedSubDictionaryId`, `selectedDayNumber`, `selectedDayName`, `setTraining`, `repetitions`, `time`, `rest`, `restBetweenSet`, `weight`, `totalTime` FROM `tbl_plan_workout` WHERE `tblPlansId` = '$planId'";

//     $res = $connect->prepare($query);
//     $res->execute();
//     if ($res->rowCount() > 0) {
//         $row = $res->fetchAll(PDO::FETCH_ASSOC);
//         for ($i=0; $i < sizeof($row); $i++) { 
//             // $subLit=$row[$i]['selectedSubDictionaryId'];
//             $subLit=$row[$i]['selectedSubDictionaryId'];

//             // echo '11111111 2= '.$row[$i]['selectedSubDictionaryId'];
//             var_dump($row[$i]['selectedSubDictionaryId']);
//             // echo '11111111 2= '.sizeof($subLit);

//             for ($j=0; $j < sizeof($subLit); $j++) { 
//                 $dictionaryId=$subLit[$j];
//                 $querydictionaryId = "SELECT `animationUrl`, `description` FROM `tbl_dictionary_sub` WHERE `id` = '$dictionaryId'";

//                 $resdictionaryId = $connect->prepare($querydictionaryId);
//                 $resdictionaryId->execute();
//                 if ($resdictionaryId->rowCount() > 0) {
//                     $item = $res->fetch(PDO::FETCH_ASSOC);

//                     $dictionaryItem=new stdClass();
//                     $dictionaryItem->animationUrl=$item['animationUrl'];
//                     $dictionaryItem->description=$item['description'];
//                     $row[$i]['selectedSubDictionaryId'][$j]=$dictionaryItem;
//                 }
//             }
//         }
//         $data = ["plan" => $row];
//         Response::respondAndDieFun($data,  'successfuly get plan');
//     }
//     Response::respondAndDieFun('',  'not exist any plan', Response::HTTP_NOT_FOUND);
// }
function getNutritionExcercise($planId, $selectedDayNumber)
{
    $planId = checkSqlInjection($planId);
    $selectedDayNumber = checkSqlInjection($selectedDayNumber);

    global $connect;
    $query = "SELECT `id`, `tblPlansId`, `selectedDayNumber`, `mealName`, `foodName` 
              FROM `tbl_plan_nutrition` 
              WHERE `tblPlansId` = '$planId' AND `selectedDayNumber` = '$selectedDayNumber'";

    $res = $connect->prepare($query);
    $res->execute();
    
    if ($res->rowCount() > 0) {
        $rows = $res->fetchAll(PDO::FETCH_ASSOC);
        
        // گروه‌بندی غذاها بر اساس mealName
        $groupedNutrition = [];
        foreach ($rows as $row) {
            $mealName = $row['mealName'];
            if (!isset($groupedNutrition[$mealName])) {
                $groupedNutrition[$mealName] = [];
            }
            $groupedNutrition[$mealName][] = $row['foodName'];
        }
        
        // تبدیل به ساختار مورد نظر
        $result = [];
        foreach ($groupedNutrition as $meal => $foods) {
            $result[] = [
                'mealName' => $meal,
                'foods' => $foods
            ];
        }
        
        $data = ["nutrition" => $result];
        Response::respondAndDieFun($data, 'successfuly get nutrition');
    }
    
    Response::respondAndDieFun('', 'not exist any nutrition', Response::HTTP_NOT_FOUND);
}
function getSubDictionaryById($subDictionaryId)
{
    $subDictionaryId = checkSqlInjection($subDictionaryId);

    global $connect;
    $query = "SELECT `animationUrl`, `description` FROM `tbl_dictionary_sub` WHERE `id` = '$subDictionaryId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $data = ["animation" => $row];
        Response::respondAndDieFun($data,  'successfuly get animation');
    }
    Response::respondAndDieFun('',  'not exist any animation', Response::HTTP_NOT_FOUND);
}
function getExercisePerformed($clientId, $planId, $planType)
{
    $planId = checkSqlInjection($planId);
    $planType = checkSqlInjection($planType);
    // nutrition => planType=1
    // workOut => planType=0

    global $connect;
    $query = "SELECT `weekNumber`, `dayNumber`, `todayDateTraingingSec` FROM `tbl_started_plan` WHERE `plansId` = '$planId' AND `clientId` = '$clientId' AND `planType` = '$planType' AND `todayDateTraingingSec` > 0";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        $data = ["plans" => $row];
        Response::respondAndDieFun($data,  'successfuly get excercise plans');
    }
    Response::respondAndDieFun('',  'not exist any excercise', Response::HTTP_NOT_FOUND);
}
function saveTrainingToday($data, $clientId)
{
    $planId = checkSqlInjection($data->planId);
    $weekNumber = checkSqlInjection($data->weekNumber);
    $dayNumber = checkSqlInjection($data->dayNumber);
    $planType = checkSqlInjection($data->planType);
    $todayDateTrainging = getMyDateTimeNow();
    $todayDateTraingingSec = time();

    global $connect;
    $query = "SELECT * FROM `tbl_started_plan` WHERE `plansId` = '$planId' AND `clientId` = '$clientId' AND `planType` = '$planType' AND `weekNumber` = '$weekNumber' AND `dayNumber` = '$dayNumber' ";
    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() == 0) {
        $query = "INSERT INTO `tbl_started_plan`(`plansId`, `clientId`, `planType`, `weekNumber`, `dayNumber`, `todayDateTrainging`, `todayDateTraingingSec`)
        VALUES ('$planId','$clientId','$planType','$weekNumber','$dayNumber','$todayDateTrainging','$todayDateTraingingSec')";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            Response::respondAndDieFun('',  'successfuly save training today');
        }
    }

    Response::respondAndDieFun('',  'occured error.', Response::HTTP_NOT_FOUND);
}
