<?php
// include_once('../../App/Utilities/Tools.php');
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../../../vendor/autoload.php';

function sendCodeToEmail($email)
{

    if (existClientEmail($email)) {
        Response::respondAndDieFun('', 'Client already exist', Response::HTTP_FOUND);
    } else {
        $code = rand(1000, 9999);
        $message = "کد احراز هویت شما در BodyBuilder (بدن ساز) : " . $code . ' می باشد.';
        $response = sendEmail($email, 'welcome to Bodybuilder', $message);
        if ($response->StatusBool) {
            $success = new stdClass();
            $success->Code = $code;
            Response::respondAndDieFun($success,  $response->StatusMessage);
        } else {
            Response::respondAndDieFun('', $response->StatusMessage, Response::HTTP_NOT_FOUND);
        }
    }
}
function existClientEmail($email)
{
    global $connect;
    $status = false;
    if (!is_null($email)) {
        $query = "SELECT id FROM tbl_client WHERE email = '$email' ";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0)
            $status = true;
    }
    return $status;
}
function sendEmail($to, $subject, $message)
{
    $mail = new PHPMailer(true);
    $response = new stdClass();
    $response->StatusBool = false;
    $response->StatusMessage = '';

    try {
        //Server settings
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
        $mail->isSMTP();                                            //Send using SMTP
        $mail->Host       = 'mail.payatarabar.ir';                     //Set the SMTP server to send through
        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
        $mail->Username   = 'info@payatarabar.ir';                     //SMTP username
        $mail->Password   = 'BdY4?qm6,,}p';                               //SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
        $mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

        //Recipients
        $mail->setFrom('info@payatarabar.ir', 'BodyBuilder');
        $mail->addAddress($to, 'Joe User');     //Add a recipient
        // $mail->addAddress('ellen@example.com');               //Name is optional
        // $mail->addReplyTo('info@example.com', 'Information');
        // $mail->addCC('cc@example.com');
        // $mail->addBCC('bcc@example.com');

        //Attachments
        // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
        // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name

        //Content
        $mail->isHTML(true);                                  //Set email format to HTML
        $mail->Subject = $subject;
        $mail->Body    = $message;
        // $mail->AltBody = $message;

        $mail->send();
        $response->StatusBool = true;
        $response->StatusMessage = 'Message has been sent';
    } catch (Exception $e) {
        $response->StatusBool = false;
        $response->StatusMessage = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }

    return $response;
}

function registerSiguUp($data)
{

    $email =  $data->email;
    if (existClientEmail($email)) {
        Response::respondAndDieFun('', 'Client already exist', Response::HTTP_FOUND);
    } else {
        global $connect;

        $password =  $data->password;


        $dateTimeNow = getMyDateTimeNow();
        $dateTimeNowSec = time();

        $queryInsertCient = "INSERT INTO `tbl_client`( `email`, `pass`, `createDateTime`, `createDateSec`, `loginTimeSec`, `active`) VALUES ('$email','$password','$dateTimeNow','$dateTimeNowSec','$dateTimeNowSec','1')";

        $resClient = $connect->prepare($queryInsertCient);
        $resClient->execute();
        if ($resClient->rowCount() > 0) {

            $clientId = $connect->lastInsertId();

            $firstName =  $data->firstName;
            $lastName =  $data->lastName;
            $clientType =  $data->clientType;
            $gender =  $data->gender;
            $age =  $data->age;
            $country =  $data->country;
            $city =  $data->city;
            $height =  $data->height;
            $weight =  $data->weight;
            $specialtySport =  $data->specialtySport;
            $specialtySportOthers =  $data->specialtySportOthers;
            $experience =  $data->experience;

            $queryInsertClientType = "INSERT INTO `tbl_client_type`(`client_id`, `firstName`, `lastName`, `clientType`, `gender`, `age`, `country`, `city`, `height`, `weight`, `specialtySport`, `specialtySportOthers`, `experience`, `createDate`, `enabled`) 
                                                            VALUES ('$clientId','$firstName','$lastName','$clientType','$gender','$age','$country','$city','$height','$weight','$specialtySport','$specialtySportOthers','$experience','$dateTimeNow','1')";

            $resClientType = $connect->prepare($queryInsertClientType);
            $resClientType->execute();
            if ($resClientType->rowCount() > 0) {
                $token = createApiToken($email, $dateTimeNowSec);
                $data = new stdClass();
                $data->Token = $token;
                Response::respondAndDieFun($data, 'Client registered');
            }
        }
        Response::respondAndDieFun($clientId, 'Error', Response::HTTP_METHOD_NOT_ALLOWED);
    }
}

function forgetPassword($email)
{
    if (existClientEmail($email)) {

        $code = rand(1000, 9999);
        $message = 'کد احراز هویت شما در بدنساز : ' . $code . ' می باشد.';
        $response = sendEmail($email, 'welcome to Bodybuilder', $message);
        if ($response->StatusBool) {
            $success = new stdClass();
            $success->Code = $code;
            Response::respondAndDieFun($success,  $response->StatusMessage);
        } else {
            Response::respondAndDieFun('', $response->StatusMessage, Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('', 'Client is no exist', Response::HTTP_NOT_FOUND);
    }
}

function SetNewPassword($email, $password)
{
    if (existClientEmail($email)) {
        if (!is_null($email) && !is_null($password)) {
            global $connect;
            $dateTimeNowSec = time();

            $query = "UPDATE `tbl_client` SET `pass`='$password', `loginTimeSec`='$dateTimeNowSec' WHERE `email` = '$email'";
            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                $token = createApiToken($email, $dateTimeNowSec);
                $data = new stdClass();
                $data->Token = $token;
                Response::respondAndDieFun($data, 'Welcome');
            }
        } else {
            Response::respondAndDieFun('',  'Client not exist', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('', 'Client is no exist', Response::HTTP_NOT_FOUND);
    }
}

function login($email, $password)
{

    global $connect;
    if (!is_null($email) && !is_null($password)) {
        $query = "SELECT `id`, `active`, `reasonDeactive` FROM `tbl_client` WHERE `email` = '$email' AND `pass` = '$password';";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $clientId = $row['id'];
            $active = $row['active'];
            $reasonDeactive = $row['reasonDeactive'];
            if ($active == 0) {
                Response::respondAndDieFun('',  $reasonDeactive, Response::HTTP_LOCKED);
            } else {
                $dateTimeNowSec = time();

                $query = "UPDATE `tbl_client` SET `loginTimeSec`='$dateTimeNowSec' WHERE `id` = '$clientId'";
                $res = $connect->prepare($query);
                $res->execute();
                if ($res->rowCount() > 0) {
                    $token = createApiToken($email, $dateTimeNowSec);
                    $data = new stdClass();
                    $data->Token = $token;
                    Response::respondAndDieFun($data, 'Welcome');
                }
            }
        } else {
            Response::respondAndDieFun('',  'Username or password is not currect', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Client not exist', Response::HTTP_NOT_FOUND);
    }
}

function createApiToken($email, $lastSignIn)
{
    $payload = ['email' => $email, 'lastSignIn' => $lastSignIn];
    $token   = JWT::encode($payload, JWT_KEY, JWT_ALG);
    return "Bearer " . $token;
}
/**
 * get access token from header
 * */
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // HEADER: Get the access token from the header
    if (!empty($headers)) {
        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
            return $matches[1];
        }
    }
    return null;
}
/**
 * Get header Authorization
 * */
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
        //print_r($requestHeaders);
        if (isset($requestHeaders['Authorization'])) {
            $headers = trim($requestHeaders['Authorization']);
        }
    }
    return $headers;
}
function checkTokenAndGetId($jwt_token)
{
    $clientId = 0;
    try {
        $payload = JWT::decode($jwt_token, new Key(JWT_KEY, JWT_ALG));

        global $connect;
        $email      = $payload->email;
        $lastSignIn = $payload->lastSignIn;

        $query = "SELECT `id`, `active`, `reasonDeactive` FROM `tbl_client` WHERE `email` = '$email' AND `loginTimeSec` = '$lastSignIn' ";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $clientId = $row['id'];
            $active = $row['active'];
            $reasonDeactive = $row['reasonDeactive'];
            if ($active == 0) {
                Response::respondAndDieFun('',  $reasonDeactive, Response::HTTP_LOCKED);
            } else {
                return  $clientId;
            }
        }
    } catch (Exception $e) {
        return  $clientId;
    }
}
