<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;

class paymentMethod
{
    private static $increaseMethod = 0;
    private static $decreaseMethod = 1;
    private static $buyPlanMethod = 2;

    public static function getIncreaseMethod()
    {
        return self::$increaseMethod;
    }
    public static function getDecreaseMethod()
    {
        return self::$decreaseMethod;
    }
    public static function getBuyPlanMethod()
    {
        return self::$buyPlanMethod;
    }
}

function getBalanceAthlete($clientId)
{
    $balance = 0;
    try {
        $balance = getBalanceAthleteAmount($clientId);
        $data=["balance"=>$balance];
        Response::respondAndDieFun($data,  'Get balance successfuly');
    } catch (\Throwable $th) {
        Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
    }
}
function getBalanceAthleteAmount($clientId)
{
    $increasementMethod = paymentMethod::getIncreaseMethod();
    $buyPlanMethod = paymentMethod::getBuyPlanMethod();
    $sumIncreasement = 0;
    $sumBuyPlan = 0;
    $currentBalance = 0;
    try {
        global $connect;
        $query = "SELECT  CAST(SUM(`amount`) AS DECIMAL(15)) + 0 AS amount FROM `tbl_payment` WHERE `clientId` = '$clientId' AND `paymentMethod` = '$increasementMethod'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $sumIncreasement = $row['amount'];
        }

        $query = "SELECT  CAST(SUM(`amount`) AS DECIMAL(15)) + 0 AS amount FROM `tbl_payment` WHERE `clientId` = '$clientId' AND `paymentMethod` = '$buyPlanMethod'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $sumBuyPlan = $row['amount'];
        }
        $currentBalance = $sumIncreasement -  $sumBuyPlan;
    } catch (\Throwable $th) {
    }

    return $currentBalance;
}
function getBalanceCoach($clientId)
{
    $balance = 0;
    try {
        $balance = getBalanceCoachAmount($clientId);
        $data=["balance"=>$balance];

        Response::respondAndDieFun($data,  'Get balance successfuly');
    } catch (\Throwable $th) {
        Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
    }
}
function getBalanceCoachAmount($clientId)
{
    $increasementMethod = paymentMethod::getIncreaseMethod();
    $decreasementMethod = paymentMethod::getDecreaseMethod();
    $buyPlanMethod = paymentMethod::getBuyPlanMethod();
    $sumIncreasement = 0;
    $sumDecreasement = 0;
    $sumBuyPlan = 0;
    $currentBalance = 0;
    try {
        global $connect;
        $query = "SELECT CAST(SUM(`amount`) AS DECIMAL(15)) + 0 AS amount FROM `tbl_payment` WHERE `clientId` = '$clientId' AND `paymentMethod` = '$increasementMethod'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $sumIncreasement =(float)$row['amount'];
        }
        $query = "SELECT CAST(SUM(`amount`) AS DECIMAL(15)) + 0 AS amount FROM `tbl_payment` WHERE `clientId` = '$clientId' AND `paymentMethod` = '$decreasementMethod'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $sumDecreasement = (float)$row['amount'];
        }
        $query = "SELECT CAST(SUM(`amount`) AS DECIMAL(15)) + 0 AS amount FROM `tbl_payment` WHERE `clientId` = '$clientId' AND `paymentMethod` = '$buyPlanMethod'";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $row = $res->fetch(PDO::FETCH_ASSOC);
            $sumBuyPlan = (float)$row['amount'];
        }
        $currentBalance = $sumIncreasement - ($sumDecreasement + $sumBuyPlan);
        return $currentBalance;
    } catch (\Throwable $th) {
        error_log('Error in getBalanceCoachAmount: ' . $th->getMessage());
        return 0;
    }
}

function getHistoryPayment($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    global $connect;
      // 1. تغییر تنظیمات PDO برای بازگرداندن اعداد به صورت عددی
      $connect->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, false);
      $connect->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

    $query = "SELECT CASE WHEN paymentMethod = 0 THEN 'increase Method' WHEN paymentMethod = 1 THEN 'decrease Method' WHEN paymentMethod = 2 THEN 'buyPlan Method' END AS 'paymentMethod', IFNULL((coachName),'--') AS 'coachName', IFNULL((planName),'--') AS 'planName', CAST(amount AS DECIMAL(15)) + 0 AS amount, insertDateTime, trackingCode, paymentStatus FROM `tbl_payment` WHERE clientId = '$clientId' ORDER BY insertDateTime DESC LIMIT $page,$pageItem";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetchAll(PDO::FETCH_ASSOC);
        array_walk($row, function(&$payment) {
            $payment['amount'] = (float)$payment['amount'];
        });
        $data=["history"=>$row];
        Response::respondAndDieFun($data,  'Inserted succefully');
    }
    Response::respondAndDieFun('',  'An error occurred.', Response::HTTP_NOT_FOUND);
}
function getInfoCreditCard($clientId)
{
    global $connect;
    $query = "SELECT `credirCardNumber`, CONCAT_WS(' ',`firstName`,`lastName`) AS fullName FROM `tbl_coaching_team` WHERE `clientId` = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        $balance = getBalanceCoachAmount($clientId);
        $row["currentBalance"]= $balance ;

        $data=["info"=>$row];
        Response::respondAndDieFun($data,  'Inserted succefully');
    }else{
        Response::respondAndDieFun('',  'You are not trgister in coach team', Response::HTTP_NOT_FOUND);    
    }
    Response::respondAndDieFun('',  'An error occurred.', Response::HTTP_NOT_FOUND);
}
function addBalance($clientId, $data)
{
    $amount = checkSqlInjection($data->amount);

    $trackingCode = checkSqlInjection($data->trackingCode);
    $paymentStatus = checkSqlInjection($data->paymentStatus);
    $insertDateTime = getMyDateTimeNow();
    $paymentMethod = paymentMethod::getIncreaseMethod();
    try {
        global $connect;
        $query = "INSERT INTO `tbl_payment`( `clientId`, `paymentMethod`, `amount`, `insertDateTime`, `trackingCode`, `paymentStatus`) 
    VALUES ('$clientId','$paymentMethod','$amount','$insertDateTime','$trackingCode','$paymentStatus')";

        $res = $connect->prepare($query);
        $res->execute();
        if ($res->rowCount() > 0) {
            $rowId = $connect->lastInsertId();
            $insertData = new stdClass();
            $insertData->paymentId = $rowId;
            $insertData->amount = $amount;
            $insertData->trackingCode = $trackingCode;
            $insertData->paymentStatus = $paymentStatus;
            $insertData->insertDateTime = $insertDateTime;

            Response::respondAndDieFun($insertData,  'Inserted succefully');
        }
    } catch (\Throwable $th) {
        Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
    }
}
function withDrawalCoach($clientId, $data)
{
    $amount = checkSqlInjection($data->amount);
    $currentBalance = getBalanceCoachAmount($clientId);
    if ($currentBalance > $amount) {
        $trackingCode = checkSqlInjection($data->trackingCode);
        $paymentStatus = checkSqlInjection($data->paymentStatus);
        $insertDateTime = getMyDateTimeNow();
        $paymentMethod = paymentMethod::getDecreaseMethod();
        try {
            global $connect;
            $query = "INSERT INTO `tbl_payment`( `clientId`, `paymentMethod`, `amount`, `insertDateTime`, `trackingCode`, `paymentStatus`) 
                                        VALUES ('$clientId','$paymentMethod','$amount','$insertDateTime','$trackingCode','$paymentStatus')";

            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                $rowId = $connect->lastInsertId();
                $insertData = new stdClass();
                $insertData->paymentId = $rowId;
                $insertData->amount = $amount;
                $insertData->trackingCode = $trackingCode;
                $insertData->paymentStatus = $paymentStatus;
                $insertData->insertDateTime = $insertDateTime;

                $currentBalance = getBalanceCoachAmount($clientId);
                $insertData->currentBalance = $currentBalance;

                Response::respondAndDieFun($insertData,  'decrasement succefully');
            }
        } catch (\Throwable $th) {
            Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Your balance is not sufficient.', Response::HTTP_NOT_FOUND);
    }
}

function BuyPlanCoach($clientId, $data)
{
    $amount = checkSqlInjection($data->amount);
    $currentBalance = getBalanceCoachAmount($clientId);
    if ($currentBalance > $amount) {
        $coachId = checkSqlInjection($data->coachId);
        $coachName = checkSqlInjection($data->coachName);
        $planId = checkSqlInjection($data->planId);
        $planName = checkSqlInjection($data->planName);
        $trackingCode = checkSqlInjection($data->trackingCode);
        $paymentStatus = checkSqlInjection($data->paymentStatus);
        $insertDateTime = getMyDateTimeNow();
        $paymentMethod = paymentMethod::getBuyPlanMethod();
        try {
            global $connect;
            $query = "INSERT INTO `tbl_payment`( `clientId`, `paymentMethod`, `coachId`, `coachName`, `planId`, `planName`,  `amount`, `insertDateTime`, `trackingCode`, `paymentStatus`) 
                                        VALUES ('$clientId','$paymentMethod','$coachId','$coachName','$planId','$planName','$amount','$insertDateTime','$trackingCode','$paymentStatus')";

            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                $rowId = $connect->lastInsertId();
                $insertData = new stdClass();
                $insertData->paymentId = $rowId;
                $insertData->amount = $amount;
                $insertData->trackingCode = $trackingCode;
                $insertData->paymentStatus = $paymentStatus;
                $insertData->insertDateTime = $insertDateTime;

                $currentBalance = getBalanceCoachAmount($clientId);
                $insertData->currentBalance = $currentBalance;

                Response::respondAndDieFun($insertData,  'Buy plan succefully');
            }
        } catch (\Throwable $th) {
            Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Your balance is not sufficient.', Response::HTTP_NOT_FOUND);
    }
}

function buyPlanAthlete($clientId, $data)
{
    $amount = checkSqlInjection($data->amount);
    $currentBalance = getBalanceAthleteAmount($clientId);
    if ($currentBalance > $amount) {
        $coachId = checkSqlInjection($data->coachId);
        $coachName = checkSqlInjection($data->coachName);
        $planId = checkSqlInjection($data->planId);
        $planName = checkSqlInjection($data->planName);
        $trackingCode = checkSqlInjection($data->trackingCode);
        $paymentStatus = checkSqlInjection($data->paymentStatus);
        $insertDateTime = getMyDateTimeNow();
        $paymentMethod = paymentMethod::getBuyPlanMethod();
        try {
            global $connect;
            $query = "INSERT INTO `tbl_payment`( `clientId`, `paymentMethod`, `coachId`, `coachName`, `planId`, `planName`, `amount`, `insertDateTime`, `trackingCode`, `paymentStatus`) 
                                        VALUES ('$clientId','$paymentMethod','$coachId','$coachName','$planId','$planName','$amount','$insertDateTime','$trackingCode','$paymentStatus')";

            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                $rowId = $connect->lastInsertId();
                $insertData = new stdClass();
                $insertData->paymentId = $rowId;
                $insertData->amount = $amount;
                $insertData->trackingCode = $trackingCode;
                $insertData->paymentStatus = $paymentStatus;
                $insertData->insertDateTime = $insertDateTime;

                $currentBalance = getBalanceAthleteAmount($clientId);
                $insertData->currentBalance = $currentBalance;

                Response::respondAndDieFun($insertData,  'Buy plan succefully');
            }
        } catch (\Throwable $th) {
            Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Your balance is not sufficient.', Response::HTTP_NOT_FOUND);
    }
}

function withdrawal($clientId, $data)
{
    $amount = checkSqlInjection($data->amount);
    $creditCard = checkSqlInjection($data->creditCard);

    $currentBalance = getBalanceCoachAmount($clientId);
    if ($currentBalance > $amount) {
        $paymentStatus = 'Withdrawal';
        $insertDateTime = getMyDateTimeNow();
        $paymentMethod = paymentMethod::getDecreaseMethod();
        try {
            global $connect;
            $query = "INSERT INTO `tbl_payment`( `clientId`, `paymentMethod`, `amount`, `insertDateTime`, `paymentStatus`) 
                                        VALUES ('$clientId','$paymentMethod','$amount','$insertDateTime','$paymentStatus')";
            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                $rowId = $connect->lastInsertId();

                $queryInsert = "INSERT INTO `tbl_request_withdraw`(`clientId`, `credit_card`, `amount`, `request_date`, `id_tbl_payment`) 
                                                    VALUES ('$clientId','$creditCard','$amount','$insertDateTime','$rowId')";

                $resInsert = $connect->prepare($queryInsert);
                $resInsert->execute();

                Response::respondAndDieFun('',  'Withdrawal succefully');
            }
        } catch (\Throwable $th) {
            Response::respondAndDieFun($th,  'An error occurred.', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Your balance is not sufficient.', Response::HTTP_NOT_FOUND);
    }
}
