<?php
include_once('../../../App/Utilities/Tools.php');

use App\Utilities\Response;

function getClientProfile($clientId)
{
    global $connect;
    $query = "SELECT t_client.email, t_clientType.firstName, t_clientType.lastName, t_clientType.profileImage, t_clientType.clientType, t_clientType.gender FROM `tbl_client` AS t_client JOIN tbl_client_type AS t_clientType ON t_client.id = t_clientType.client_id WHERE t_client.id = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        Response::respondAndDieFun($row,  'Get profile data successful');
    } else {
        Response::respondAndDieFun('',  'Not found profile data', Response::HTTP_NOT_FOUND);
    }
}
function getProfile($clientId)
{
    global $connect;
    $query = "SELECT t_clientType.clientType, t_client.email, t_clientType.firstName, t_clientType.lastName, t_clientType.profileImage, t_clientType.age, t_clientType.country, t_clientType.city, t_clientType.gender, t_clientType.weight, t_clientType.height, t_clientType.waist, t_clientType.hip, t_clientType.arm, t_clientType.sportDiscipline, t_clientType.experience, t_clientType.mainReasonWorkingOut, t_clientType.perWeekExercise, t_clientType.previousMedicalConditions, t_clientType.detailPreviousConditions, t_clientType.currentlyMedication, t_clientType.detailCurrentlyConditions FROM `tbl_client` AS t_client JOIN tbl_client_type AS t_clientType ON t_client.id = t_clientType.client_id WHERE t_client.id = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        Response::respondAndDieFun($row,  'Get profile data successful');
    } else {
        Response::respondAndDieFun('',  'Not found profile data', Response::HTTP_NOT_FOUND);
    }
}
function getAllPlansAthlete($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    $dataPlan = [];
    global $connect;
    $nowDateTimeToExpire = time();
    // کوئری برای برنامه‌های تمرینی
    $queryWorkoutPlan = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_request.coachId AS coachId, t_plan.id AS planId, t_plan.workOutName planName, 'workOut' AS planType, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_request.requestDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_request_plan AS t_request JOIN tbl_plans AS t_plan ON t_request.planId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_request.clientId = '$clientId' ORDER BY t_request.requestDateSec DESC LIMIT $page,$pageItem";

    $resWorkoutPlan = $connect->prepare($queryWorkoutPlan);
    $resWorkoutPlan->execute();
    if ($resWorkoutPlan->rowCount() > 0) {
        foreach ($resWorkoutPlan->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    // کوئری برای برنامه‌های تغذیه‌ای
    $queryNutrition = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 1 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_request.coachId AS coachId, t_plan.id AS planId, t_plan.nutritionName planName, 'nutrition' AS planType, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 1 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_request.requestDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_request_plan AS t_request JOIN tbl_plans AS t_plan ON t_request.planId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_request.clientId = '$clientId' ORDER BY t_request.requestDateSec DESC LIMIT $page,$pageItem";

    $resNutrition = $connect->prepare($queryNutrition);
    $resNutrition->execute();
    if ($resNutrition->rowCount() > 0) {
        foreach ($resNutrition->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    if (sizeof($dataPlan) > 0) {
        $data = ["plans" => $dataPlan];
        Response::respondAndDieFun($data,  'successfuly get plans');
    }
    Response::respondAndDieFun('',  'not found plan.', Response::HTTP_NOT_FOUND);
}
function getMyCoach($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    global $connect;
    // $queryWorkoutPlan = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_coach.gender AS gender, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.sportDescipline, t_coach.typeService AS plan, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_request_plan AS t_request JOIN tbl_client_type AS t_client ON t_request.coachId = t_client.client_id JOIN tbl_coaching_team AS t_coach ON t_request.coachId = t_coach.clientId WHERE t_request.clientId = '$clientId' AND t_request.planId IS NOT NULL LIMIT $page,$pageItem;";
    $queryWorkoutPlan = "SELECT t_coach.clientId AS coachId, t_coach.id AS coachTeamId, t_coach.gender AS gender, t_client.profileImage AS profileImage, CONCAT(t_coach.firstName,' ',t_coach.lastName) AS profileName, t_coach.sportDescipline, t_coach.typeService AS plan, IFNULL((SELECT SUM(rate) FROM `tbl_rate` WHERE clientId = t_coach.clientId),0) AS rate FROM tbl_saved_coach AS t_sCoach JOIN tbl_coaching_team AS t_coach ON t_sCoach.coachId = t_coach.id JOIN tbl_client_type AS t_client ON t_client.client_id = t_coach.clientId WHERE t_sCoach.clientId = '$clientId' LIMIT $page,$pageItem;";

    $resWorkoutPlan = $connect->prepare($queryWorkoutPlan);
    $resWorkoutPlan->execute();
    if ($resWorkoutPlan->rowCount() > 0) {
        $rows = $resWorkoutPlan->fetchAll(PDO::FETCH_ASSOC);

        for ($i = 0; $i < sizeof($rows); $i++) {
            $rows[$i]['plan'] = fixDoubleEncodedJson($rows[$i]['plan']);
        }

        $data = ["coachs" => $rows];
        Response::respondAndDieFun($data,  'successfuly get my coach');
    }
    Response::respondAndDieFun('',  'not found coach.', Response::HTTP_NOT_FOUND);
}
function editProfile($data, $clientId)
{
    global $connect;
    $profileImage = checkSqlInjection($data->profileImage);
    $firstName = checkSqlInjection($data->firstName);
    $lastName = checkSqlInjection($data->lastName);


    $gender = checkSqlInjection($data->gender);
    $age = checkSqlInjection($data->age);
    $country = checkSqlInjection($data->country);
    $city = checkSqlInjection($data->city);
    $height = checkSqlInjection($data->height);
    $weight = checkSqlInjection($data->weight);
    $waist = checkSqlInjection($data->waist);
    $hip = checkSqlInjection($data->hip);
    $arm = checkSqlInjection($data->arm);
    $sportDiscipline = checkSqlInjection($data->sportDiscipline);
    $experience = checkSqlInjection($data->experience);
    $mainReasonWorkingOut = checkSqlInjection($data->mainReasonWorkingOut);
    $perWeekExercise = checkSqlInjection($data->perWeekExercise);
    $previousMedicalConditions = checkSqlInjection($data->previousMedicalConditions);
    $detailPreviousConditions = checkSqlInjection($data->detailPreviousConditions);
    $currentlyMedication = checkSqlInjection($data->currentlyMedication);
    $detailCurrentlyConditions = checkSqlInjection($data->detailCurrentlyConditions);


    $query = "UPDATE `tbl_client_type` SET `firstName`='$firstName',`lastName`='$lastName',`profileImage`='$profileImage',`gender`='$gender',`age`='$age',`country`='$country',`city`='$city',`height`='$height',`weight`='$weight',`waist`='$waist',`hip`='$hip',`arm`='$arm',`sportDiscipline`='$sportDiscipline',`experience`='$experience',`mainReasonWorkingOut`='$mainReasonWorkingOut',`perWeekExercise`='$perWeekExercise',`previousMedicalConditions`='$previousMedicalConditions',`detailPreviousConditions`='$detailPreviousConditions',`currentlyMedication`='$currentlyMedication',`detailCurrentlyConditions`='$detailCurrentlyConditions' WHERE `client_id` = '$clientId' ;";

    $res = $connect->prepare($query);
    $res->execute();

    Response::respondAndDieFun('',  'Edit profile data successful');
}
function uploadImageProfile($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = __DIR__ . '/../../uploads/profile_images/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
        $uploadDir = UPLOAD_DIR;
        $fileUrl = $uploadDir . 'profile_images/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadImageProfile($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/profile_images/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/profile_images/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfully upload file'); // تصحیح املایی
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }
function uploadImageNational($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = __DIR__ . '/../../uploads/profile_noational_coach/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
        $uploadDir = UPLOAD_DIR;
        $fileUrl = $uploadDir . 'profile_noational_coach/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadImageNational($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/profile_noational_coach/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/profile_noational_coach/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfully upload file'); // تصحیح املایی
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }
function uploadImageCerificate($file)
{
    // پوشه‌ای برای ذخیره فایل‌ها
    $uploadDir = '../../../uploads/profile_certificate_coach/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
    }

    // ایجاد نام فایل کاملاً تصادفی
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
    $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
    $uploadFile = $uploadDir . $randomFileName;

    // ذخیره فایل
    if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
        // موفقیت‌آمیز
        // $fileUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/uploads/profile_images/' . $randomFileName;
        $uploadDir = UPLOAD_DIR;
        $fileUrl = $uploadDir . 'profile_certificate_coach/' . $randomFileName;
        $data = ["url" => $fileUrl];
        Response::respondAndDieFun($data,  'successfuly upload file');
    } else {
        Response::respondAndDieFun('',  'Could not upload file.', Response::HTTP_NOT_FOUND);
    }
}
// function uploadImageCerificate($file)
// {
//     // پوشه‌ای برای ذخیره فایل‌ها (مسیر مطلق نسبت به فایل جاری)
//     $uploadDir = __DIR__ . '/uploads/profile_certificate_coach/';
//     if (!is_dir($uploadDir)) {
//         mkdir($uploadDir, 0777, true); // ایجاد پوشه اگر وجود نداشته باشد
//     }

//     // ایجاد نام فایل کاملاً تصادفی
//     $extension = pathinfo($file['name'], PATHINFO_EXTENSION); // گرفتن پسوند فایل
//     $randomFileName = bin2hex(random_bytes(16)) . '.' . $extension; // نام فایل تصادفی + پسوند
//     $uploadFile = $uploadDir . $randomFileName;

//     // ذخیره فایل
//     if (move_uploaded_file($file['tmp_name'], $uploadFile)) {
//         // موفقیت‌آمیز
//         $fileUrl = 'https://dl.payatarabar.ir/bodybuilder/Client/uploads/profile_certificate_coach/' . $randomFileName;
//         $data = ["url" => $fileUrl];
//         Response::respondAndDieFun($data, 'successfully upload file'); // تصحیح املایی
//     } else {
//         Response::respondAndDieFun('', 'Could not upload file.', Response::HTTP_NOT_FOUND);
//     }
// }
function contactUs($data, $clientId)
{
    global $connect;
    $feedBack = checkSqlInjection($data->feedBack);
    $dateFeedBack = getMyDateTimeNow();
    $query = "INSERT INTO `tbl_contact_us`(`clientId`, `feedBack`, `dateFeedBack`) VALUES ('$clientId','$feedBack','$dateFeedBack')";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        Response::respondAndDieFun('',  'successfuly save feedBack');
    }
    Response::respondAndDieFun('',  'error ocoured.', Response::HTTP_NOT_FOUND);
}
function registerCoachingTeam($data, $clientId)
{
    global $connect;
    $firstName = checkSqlInjection($data->firstName);
    $lastName = checkSqlInjection($data->lastName);
    $age = checkSqlInjection($data->age);
    $notionalIdCard = checkSqlInjection($data->notionalIdCard);
    $gender = checkSqlInjection($data->gender);

    $notionalIdCardPhoto = checkSqlInjection($data->notionalIdCardPhoto);
    $phoneNumber = checkSqlInjection($data->phoneNumber);
    $email = checkSqlInjection($data->email);
    $country = checkSqlInjection($data->country);
    $city = checkSqlInjection($data->city);
    $postalCode = checkSqlInjection($data->postalCode);
    $address = checkSqlInjection($data->address);
    $credirCardNumber = checkSqlInjection($data->credirCardNumber);
    $ibanNumber = checkSqlInjection($data->ibanNumber);
    $educationalDegree = checkSqlInjection($data->educationalDegree);
    $sportDescipline = $data->sportDescipline;

    $sportDescipline = json_encode($sportDescipline, true);
    // تبدیل آرایه sportDescipline به رشته
    // $sportDescipline = implode(',', $data->sportDescipline);
    // $sportDescipline = implode(',', $data->sportDescipline);
    // $sportDescipline = ["fitness","footbal"];
    // var_dump($sportDescipline);

    $feeAmount = checkSqlInjection($data->feeAmount);
    $typeService = $data->typeService;
    $typeService = json_encode($typeService, true);

    $yearsExperience = checkSqlInjection($data->yearsExperience);
    $certificatePhoto = checkSqlInjection($data->certificatePhoto);

    $dateTimeNow = getMyDateTimeNow();

    $query = "INSERT INTO `tbl_coaching_team` (`clientId`, `firstName`, `lastName`, `age`, `notionalIdCard`, `notionalIdCardPhoto`, `gender`, `phoneNumber`, `email`, `country`, `city`, `postalCode`, `address`, `credirCardNumber`, `ibanNumber`, `educationalDegree`, `sportDescipline`, `feeAmount`, `typeService`, `yearsExperience`, `certificatePhoto`, `createDate`) 
              VALUES ('$clientId', '$firstName', '$lastName', '$age', '$notionalIdCard', '$notionalIdCardPhoto', '$gender', '$phoneNumber', '$email', '$country', '$city', '$postalCode', '$address', '$credirCardNumber', '$ibanNumber', '$educationalDegree', '$sportDescipline', '$feeAmount', '$typeService', '$yearsExperience', '$certificatePhoto', '$dateTimeNow')
              ON DUPLICATE KEY UPDATE 
              `firstName` = VALUES(`firstName`),
              `lastName` = VALUES(`lastName`),
              `age` = VALUES(`age`),
              `notionalIdCard` = VALUES(`notionalIdCard`),
              `notionalIdCardPhoto` = VALUES(`notionalIdCardPhoto`),
              `gender` = VALUES(`gender`),
              `phoneNumber` = VALUES(`phoneNumber`),
              `email` = VALUES(`email`),
              `country` = VALUES(`country`),
              `city` = VALUES(`city`),
              `postalCode` = VALUES(`postalCode`),
              `address` = VALUES(`address`),
              `credirCardNumber` = VALUES(`credirCardNumber`),
              `ibanNumber` = VALUES(`ibanNumber`),
              `educationalDegree` = VALUES(`educationalDegree`),
              `sportDescipline` = VALUES(`sportDescipline`),
              `feeAmount` = VALUES(`feeAmount`),
              `typeService` = VALUES(`typeService`),
              `yearsExperience` = VALUES(`yearsExperience`),
              `certificatePhoto` = VALUES(`certificatePhoto`),
              `createDate` = VALUES(`createDate`)";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        Response::respondAndDieFun('',  'save your data');
    } else {
        Response::respondAndDieFun('',  'occured error', Response::HTTP_NOT_FOUND);
    }
}
function getCoachingTeam($clientId)
{
    global $connect;

    try {
        $query = "SELECT * FROM `tbl_coaching_team` WHERE `clientId` = :clientId";
        $stmt = $connect->prepare($query);
        $stmt->bindParam(':clientId', $clientId, PDO::PARAM_STR);
        $stmt->execute();

        // دریافت نتیجه
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            // تبدیل رشته sportDescipline به آرایه
            $result['sportDescipline'] = explode(',', $result['sportDescipline']);

            return $result;
        } else {
            return null;
        }
    } catch (PDOException $e) {
        echo "خطا: " . $e->getMessage();
        return null;
    }
}

function getSavedPlanAthlete($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    $dataPlan = [];
    global $connect;
    $nowDateTimeToExpire = time();
    // کوئری برای برنامه‌های تمرینی
    $queryWorkoutPlan = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_sPlan.plansId AS planId, t_plan.clientId AS coachId, t_plan.workOutName planName, 'workOut' AS planType, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_plan.createDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' ORDER BY t_splan.insertDateSec DESC LIMIT $page,$pageItem";

    $resWorkoutPlan = $connect->prepare($queryWorkoutPlan);
    $resWorkoutPlan->execute();
    if ($resWorkoutPlan->rowCount() > 0) {
        foreach ($resWorkoutPlan->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    // کوئری برای برنامه‌های تغذیه‌ای
    $queryNutrition = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 1 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_sPlan.plansId AS planId, t_plan.clientId AS coachId, t_plan.nutritionName planName, 'nutrition' AS planType, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 1 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_plan.createDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_saved_plan AS t_sPlan JOIN tbl_plans AS t_plan ON t_sPlan.plansId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_sPlan.clientId = '$clientId' ORDER BY t_splan.insertDateSec DESC LIMIT $page,$pageItem";

    $resNutrition = $connect->prepare($queryNutrition);
    $resNutrition->execute();
    if ($resNutrition->rowCount() > 0) {
        foreach ($resNutrition->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    if (sizeof($dataPlan) > 0) {
        $data = ["plans" => $dataPlan];
        Response::respondAndDieFun($data,  'successfuly get plans');
    }
    Response::respondAndDieFun('',  'not found plan.', Response::HTTP_NOT_FOUND);
}
function changePassword($data, $clientId)
{
    $oldPassword = checkSqlInjection($data->oldPassword);
    $newPassword = checkSqlInjection($data->newPassword);
    if (!is_null($oldPassword) && !is_null($newPassword)) {
        global $connect;

        $queryWorkoutPlan = "SELECT `id` FROM `tbl_client` WHERE `id` = '$clientId' AND `pass` = '$oldPassword'";

        $resWorkoutPlan = $connect->prepare($queryWorkoutPlan);
        $resWorkoutPlan->execute();
        if ($resWorkoutPlan->rowCount() > 0) {
            $query = "UPDATE `tbl_client` SET `pass`='$newPassword' WHERE `id` = '$clientId'";

            $res = $connect->prepare($query);
            $res->execute();
            if ($res->rowCount() > 0) {
                Response::respondAndDieFun('', 'Changed password');
            } else {
                Response::respondAndDieFun('',  'Error is ocoured', Response::HTTP_NOT_FOUND);
            }
        } else {
            Response::respondAndDieFun('',  'Old password is not currect', Response::HTTP_NOT_FOUND);
        }
    } else {
        Response::respondAndDieFun('',  'Client not exist', Response::HTTP_NOT_FOUND);
    }
}

function getAllPlansCoach($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    $dataPlan = [];
    global $connect;
    $nowDateTimeToExpire = time();
    // کوئری برای برنامه‌های تمرینی
    $queryWorkoutPlan = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.workOutPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_plan.id AS planId, t_plan.workOutName planName, 'workOut' AS planType, t_plan.workOutPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.workOutTrainingDays) * t_plan.workOutPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_request.requestDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_request_plan AS t_request JOIN tbl_plans AS t_plan ON t_request.planId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_request.clientId = '$clientId' OR t_request.coachId = '$clientId' ORDER BY t_request.requestDateSec DESC LIMIT $page,$pageItem";

    $resWorkoutPlan = $connect->prepare($queryWorkoutPlan);
    $resWorkoutPlan->execute();
    if ($resWorkoutPlan->rowCount() > 0) {
        foreach ($resWorkoutPlan->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    // کوئری برای برنامه‌های تغذیه‌ای
    $queryNutrition = "SELECT IFNULL((((SELECT MIN(todayDateTraingingSec) FROM `tbl_started_plan` WHERE`planType` = 0 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) + ((t_plan.nutritionPlanDuration * 7) * 86400)) < $nowDateTimeToExpire),0) AS expire, t_plan.id AS planId, t_plan.nutritionName planName, 'nutrition' AS planType, t_plan.nutritionPlanDuration AS durationWeek, (JSON_LENGTH(t_plan.nutritionTrainingDays) * t_plan.nutritionPlanDuration) AS totalDay,(SELECT COUNT(*) CountTraining FROM `tbl_started_plan` WHERE `planType` = 1 AND `plansId` = t_plan.id AND `clientId` = t_plan.clientId AND todayDateTraingingSec IS NOT NULL) AS passedTrainingDay, DATE_FORMAT(t_request.requestDate, '%Y-%m-%d') AS createAt, CONCAT(t_client.firstName,' ',t_client.lastName) AS coachName FROM tbl_request_plan AS t_request JOIN tbl_plans AS t_plan ON t_request.planId = t_plan.id JOIN tbl_client_type AS t_client ON t_plan.clientId = t_client.client_id WHERE t_request.clientId = '$clientId' OR t_request.coachId = '$clientId' ORDER BY t_request.requestDateSec DESC LIMIT $page,$pageItem";

    $resNutrition = $connect->prepare($queryNutrition);
    $resNutrition->execute();
    if ($resNutrition->rowCount() > 0) {
        foreach ($resNutrition->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $dataPlan[] = $row;
        }
    }
    if (sizeof($dataPlan) > 0) {
        $data = ["plans" => $dataPlan];
        Response::respondAndDieFun($data,  'successfuly get plans');
    }
    Response::respondAndDieFun('',  'not found plan.', Response::HTTP_NOT_FOUND);
}

function getRegisteredCoach($clientId)
{
    global $connect;
    $query = "SELECT `firstName`, `lastName`, `age`, `notionalIdCard`, `notionalIdCardPhoto`, `gender`, `phoneNumber`, `email`, `country`, `city`, `postalCode`, `address`, `credirCardNumber`, `ibanNumber`, `educationalDegree`, `sportDescipline`, `feeAmount`, `typeService`, `yearsExperience`, `certificatePhoto` FROM `tbl_coaching_team` WHERE `clientId` = '$clientId'";

    $res = $connect->prepare($query);
    $res->execute();
    if ($res->rowCount() > 0) {
        $row = $res->fetch(PDO::FETCH_ASSOC);
        // اصلاح مقادیر sportDescipline و typeService
        $row['sportDescipline'] = fixDoubleEncodedJson($row['sportDescipline']);
        $row['typeService'] = fixDoubleEncodedJson($row['typeService']);

        Response::respondAndDieFun($row,  'successfuly get registered coach');
    }
    Response::respondAndDieFun('',  'not found coach.', Response::HTTP_NOT_FOUND);
}
function fixDoubleEncodedJson($value)
{
    if (empty($value)) return null;

    try {
        // اگر مقدار با کوتیشن احاطه شده است
        $trimmed = trim($value, '"');

        // اگر هنوز یک رشته JSON معتبر است
        if (json_decode($trimmed) !== null) {
            return json_decode($trimmed, true);
        }

        // اگر به صورت مستقیم آرایه است
        return json_decode($value, true);
    } catch (Exception $e) {
        error_log("Error fixing double encoded JSON: " . $e->getMessage());
        return null;
    }
}
function getMyRate($clientId)
{
    global $connect;
    $queryCount = "SELECT IFNULL(SUM(`rate`),0 )AS rate, COUNT(*) AS reviewCount FROM `tbl_rate` WHERE `clientId` = '$clientId'";
    $resCount = $connect->prepare($queryCount);
    $resCount->execute();
    if ($resCount->rowCount() > 0) {
        $row = $resCount->fetch(PDO::FETCH_ASSOC);
        $data = ["data" => $row];
        Response::respondAndDieFun($data,  'successfuly get review');
    }
    Response::respondAndDieFun('',  'not found coach.', Response::HTTP_NOT_FOUND);
}
function getMyAthlete($clientId, $Page)
{
    $page = checkSqlInjection($Page);
    $pageItem = PAGING_ITEM;
    global $connect;
    $queryMyAthlete = "SELECT t_requestPlan.clientId AS clientId, t_requestPlan.firstName AS firstName, t_requestPlan.lastName AS lastName, t_client.profileImage AS profileImage FROM `tbl_request_plan` AS t_requestPlan JOIN tbl_client_type AS t_client ON t_requestPlan.clientId = t_client.client_id WHERE t_requestPlan.coachId = '$clientId' LIMIT $page,$pageItem;";

    $resMyAthlete = $connect->prepare($queryMyAthlete);
    $resMyAthlete->execute();
    if ($resMyAthlete->rowCount() > 0) {
        $row = $resMyAthlete->fetchAll(PDO::FETCH_ASSOC);
        $data = ["athlete" => $row];
        Response::respondAndDieFun($data,  'successfuly get athlete');
    }
    Response::respondAndDieFun('',  'not found athlete.', Response::HTTP_NOT_FOUND);
}
