'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/AssetManifest.bin": "a7063708dbb5faf12c7c8626126e04e1",
"assets/AssetManifest.bin.json": "a622ef2852aa9f925cb0aa4eed7cbec0",
"assets/AssetManifest.json": "034054211697b55324b14b69d15328a0",
"assets/assets/fonts/Roboto_Regular.ttf": "5673da52c98bb6cb33ada5aaf649703e",
"assets/assets/img/images/Chat/ic_coach.png": "b1155c2cf29c9f151e2b96c96720b4f9",
"assets/assets/img/images/Chat/ic_plane_icon.png": "aedf78a4ace275a2f81c703b99f89b89",
"assets/assets/img/images/Chat/ic_play_voice.png": "50a47915dbf1b228692a1df77d1a2ddb",
"assets/assets/img/images/Chat/ic_profile_chat2.png": "e5741d422a0781b0ee19d4abe93592ea",
"assets/assets/img/images/Chat/ic_voice.png": "498f90904d30e078a24e3f206a239270",
"assets/assets/img/images/Chat/img_attachment.png": "bcc243cdb1a231c41b7b5b3ffff27b02",
"assets/assets/img/images/Chat/img_image_message.jpg": "5c4e9695308f326f686d0307311feb1b",
"assets/assets/img/images/Chat/img_profile2.jpg": "daa71e0d66f64bf88fc7f0a42dbf71d3",
"assets/assets/img/images/Chat/img_profile3.jpg": "68957618089b6414ffd78f8752c19857",
"assets/assets/img/images/Chat/img_profile4.jpg": "2779559424e95410b8cd3d851156d05f",
"assets/assets/img/images/Chat/img_profile_chat1.jpg": "c5b3c0c28949a7e021f625b08f4dc162",
"assets/assets/img/images/Community/ic_filter.png": "86bf8b89ad9778ca219d0b05500832f3",
"assets/assets/img/images/Community/ic_gender.png": "22935c697861834a660be7d60c2d5b19",
"assets/assets/img/images/Community/ic_label_price.png": "d23b7007d0ce6ccfc1372861c6e8bd98",
"assets/assets/img/images/Community/ic_plane.png": "fdd9ed86129797731f096b2798343e31",
"assets/assets/img/images/Community/ic_price.png": "49032b6e83846474364c4735f0096e6a",
"assets/assets/img/images/Community/ic_skill.png": "4f27ae3777b612fcbea658b492de5778",
"assets/assets/img/images/Community/ic_time.png": "88ee9973a97bc3dba481039ffd03892e",
"assets/assets/img/images/Community/img_profile1.jpg": "7bae579f1831b4b72cc3ce5444949239",
"assets/assets/img/images/Community/img_profile2.jpg": "111e530906a9fce79fda766db38d4ae0",
"assets/assets/img/images/Community/img_profile3.jpg": "c71df5f85a8a831721d5376c8173af2d",
"assets/assets/img/images/Community/img_profile4.jpg": "48434d8bad20f38770969bd65a601b2c",
"assets/assets/img/images/Community/img_profile5.jpg": "293dbc370f645da5834eba519e4d2344",
"assets/assets/img/images/Community/img_review.jpg": "af0dc936012e76e3cb561773824341ef",
"assets/assets/img/images/CreateNewPlan/ic_biceps.png": "39f10f9cc9f3a77e0d61bc370d5e1798",
"assets/assets/img/images/CreateNewPlan/ic_chest.png": "c4a4878280cf90e9dc1aa0c223d0b43e",
"assets/assets/img/images/CreateNewPlan/ic_hourglass.png": "f117eb2b27ef02b1549bd4685405ee10",
"assets/assets/img/images/CreateNewPlan/ic_lats.png": "0d3091eb1db4ea1d63fbc85395492f11",
"assets/assets/img/images/CreateNewPlan/ic_legs.png": "47f9bc878658fbf5ae7606d1a5d6d6b1",
"assets/assets/img/images/CreateNewPlan/ic_nutrition.png": "967af5c30d71a7b89f54a4cfe00fdaef",
"assets/assets/img/images/CreateNewPlan/ic_other.png": "5e97b178cb6e5fa314b671de2030e3aa",
"assets/assets/img/images/CreateNewPlan/ic_repeat.png": "07aadd7fe4cb1bd547f11bae1254c352",
"assets/assets/img/images/CreateNewPlan/ic_set.png": "e924eba3a9c5461e0a2e81fbebdff415",
"assets/assets/img/images/CreateNewPlan/ic_set_name.png": "a4b8f682f07bf00b2e23f8ae16cea2c2",
"assets/assets/img/images/CreateNewPlan/ic_shoulders_and_back.png": "ecf95c729ad61cd33687f6d7f02f5a61",
"assets/assets/img/images/CreateNewPlan/ic_success.png": "e5a74d2448ebf8b0d80c225f405bed25",
"assets/assets/img/images/CreateNewPlan/ic_weight.png": "30f4fa9a292fc279f7328eb2345b805e",
"assets/assets/img/images/CreateNewPlan/ic_worout_plan.png": "5bdab27f4b566be2e7d668f6c1550336",
"assets/assets/img/images/CreateNewPlan/img_set1.png": "3214078b19990a86ab4c9da2df68b739",
"assets/assets/img/images/CreateNewPlan/img_set2.png": "af0b24463a17ed3176c54328fea68bde",
"assets/assets/img/images/CreateNewPlan/img_set3.png": "3214078b19990a86ab4c9da2df68b739",
"assets/assets/img/images/Date/background.jpg": "176c42fbae0fcd0e073c2167dc1ff710",
"assets/assets/img/images/Date/ic_add.png": "af099c89d236e4f1fd71df7ae9cdf419",
"assets/assets/img/images/Date/ic_edit.png": "35c6016ab344ddf315f0dc08da925f2a",
"assets/assets/img/images/Date/ic_progressbar.png": "0936351ca8da78aa4f7522290c7db994",
"assets/assets/img/images/Home/ic_details.png": "a56182a8026e6fa822bc05f8529883bc",
"assets/assets/img/images/Home/ic_equipments.png": "1e1d53e4d5b0172028856f5467feee3b",
"assets/assets/img/images/Home/ic_muscles.png": "6283112cf7cf93bba552c9900f43004c",
"assets/assets/img/images/Home/ic_nutrition1.png": "7097a5be84e300100486ff70454a3755",
"assets/assets/img/images/Home/ic_nutrition2.png": "4d35f1cc6ce0c34a1503650504d94a03",
"assets/assets/img/images/Home/ic_nutrition3.png": "a9303c51f80c3d6eba1212ab021d8f4b",
"assets/assets/img/images/Home/ic_nutrition4.png": "acf1659cc9e525e9b4f2b52921d1fe95",
"assets/assets/img/images/Home/ic_other.png": "eda6b23e27db0d9d0a9824f34e7d4b62",
"assets/assets/img/images/Home/ic_plans.png": "92ee9aa710119b307ed614088aad6577",
"assets/assets/img/images/Home/ic_supplments.png": "48443c5a17f3f089ef5cd2fb664a80b1",
"assets/assets/img/images/Home/ic_triceps.png": "ad6d0cc9430e827d6dc886b08363b361",
"assets/assets/img/images/Home/ic_working_training_day.png": "3214078b19990a86ab4c9da2df68b739",
"assets/assets/img/images/Home/ic_workout_fire.png": "64e9a1ad8bb27f916c57bbfc6cc21be1",
"assets/assets/img/images/Home/img_banner1.png": "b55b02a81edfa6a6262e7eba2929b44f",
"assets/assets/img/images/Home/img_banner2.png": "a688a3650dd3c0b85ad82a5e67ad0c54",
"assets/assets/img/images/Home/img_banner3.png": "221ebbcfe79535a2fe3a05306262d954",
"assets/assets/img/images/Home/img_header_workout_day.jpg": "a97f563c1c53df96283a9e6b91c2d20c",
"assets/assets/img/images/Home/img_more_plan1.jpg": "c5fcb596574de5e728972b6d9765e5f1",
"assets/assets/img/images/Home/img_plan1.jpg": "865259e5e583af53a81c71c6ae77d2c8",
"assets/assets/img/images/Home/img_plan2.jpg": "65fa898cae91786863b7dde6f2044e01",
"assets/assets/img/images/Home/img_plan_nutrition1.jpg": "9d754332ef4842a0c3f7132243bcc327",
"assets/assets/img/images/Home/img_plan_nutrition2.jpg": "ce3c4ed814ea63b042338a9ebb7a17a2",
"assets/assets/img/images/LearnMore/ic_instagram.png": "fa4215dff818d136ecdfd533fb6c6d7a",
"assets/assets/img/images/LearnMore/ic_telegram.png": "9b97725871de0ea49f7c568d0f07e8b9",
"assets/assets/img/images/LearnMore/ic_you_tube.png": "91169726761a83882b0c615a9bc4451b",
"assets/assets/img/images/loginSignUp/ic_lock.png": "5696085b8fc2dffc447586390d42fddb",
"assets/assets/img/images/loginSignUp/ic_new_pass.png": "40e84e9f6bda60be3d470d886ec127d3",
"assets/assets/img/images/loginSignUp/ic_verification_code.png": "3e1d7c9ad41745ca1733eb3d637d04a7",
"assets/assets/img/images/loginSignUp/img_login.jpg": "9bb771b741a73852eba7cc592f5c7ce6",
"assets/assets/img/images/loginSignUp/img_signup.jpg": "a2a25ba197bf27d45e25e342ff382138",
"assets/assets/img/images/Profile/ic_add_balance.png": "50bfff4fffb258b9b3fa575ff18b8243",
"assets/assets/img/images/Profile/Ic_change_password.png": "8b0bfe5c5a7948d0fe0616ee0162833e",
"assets/assets/img/images/Profile/ic_cm.png": "27ae7b51ba3d448b0a75a581a9d695d7",
"assets/assets/img/images/Profile/ic_contact.png": "d7968f0cc2bb3eaced0f0d5880842d09",
"assets/assets/img/images/Profile/ic_contact_us.png": "b747462084fdb3b730ad994153db2ddd",
"assets/assets/img/images/Profile/ic_financial.png": "fe863a0797ae92a18c40ef4c88c02b22",
"assets/assets/img/images/Profile/ic_join_our_coach.png": "4fdac2442721f4acfd2df57e5ab40ec4",
"assets/assets/img/images/Profile/ic_kg.png": "5c080dfd9a1acb8a4fbf130de95492e5",
"assets/assets/img/images/Profile/ic_language.png": "7c0f38950eec8a7b60c30b2c0ad9b1e0",
"assets/assets/img/images/Profile/ic_learn_more.png": "ed70a0b4b4dbc2acf64260bb17640a8e",
"assets/assets/img/images/Profile/ic_log_out.png": "34bb9a45d336eaa5228b6cb7728725fd",
"assets/assets/img/images/Profile/ic_my_activity_info.png": "63dc73f52d5e7eb594c02c47a76b571e",
"assets/assets/img/images/Profile/ic_professional_info.png": "6d33dd8aa14880bf3eb5d2123e99bebc",
"assets/assets/img/images/Profile/ic_profile_info.png": "11f3cb4aa31efd50f1626e55b2c29d3c",
"assets/assets/img/images/Profile/ic_rate_us.png": "2c5380eb8f0e16a50afabcfccaf9f23b",
"assets/assets/img/images/Profile/ic_saved_info.png": "6ca1f1b3eaaaa3b558ac6097544876e1",
"assets/assets/img/images/Profile/ic_sepah_bank.png": "72914dc69e1346d0a0c5cd67d2a0ec80",
"assets/assets/img/images/Profile/ic_share.png": "5306f2bbbe7ab3e2e2fa7770f56d17e7",
"assets/assets/img/images/Profile/ic_success.png": "85e76357b5aa051779e312944c5e48f0",
"assets/assets/img/images/Profile/ic_terminate.png": "3f501780aa82db32568a65d97ed3dcc6",
"assets/assets/img/images/Profile/ic_wallet_info.png": "2578824a4392d2324c01b82b19bcc02f",
"assets/assets/img/images/Profile/ic_withdrawal.png": "6a70c2ae39e91ca517f5045793f880f5",
"assets/assets/img/images/Profile/img_header_activity.jpg": "ec38860df6dd6e21b9e4acd5ce470029",
"assets/assets/img/images/Profile/img_men_athlete.jpg": "ebe1b7cf221266344c84f364a7515d12",
"assets/assets/img/images/Profile/img_men_coach.jpg": "c979561e25526eb963acb49202ecc11c",
"assets/assets/img/images/Profile/img_profile_activity.jpg": "daa71e0d66f64bf88fc7f0a42dbf71d3",
"assets/assets/img/images/Profile/img_upload_photo_card.png": "1ea8ff5120310db89752c19690a5275f",
"assets/assets/img/images/Profile/img_women_athlete.jpg": "0d73d63cf25ffa2e92a92c2cdda4b480",
"assets/assets/img/images/Profile/img_women_coach.jpg": "84b736f3c63af440a70fcc9ae58dab10",
"assets/assets/img/images/RouteNavigation/ic_chat.png": "9d81d80e84f782b25bf89e395626b8f6",
"assets/assets/img/images/RouteNavigation/ic_community.png": "9aebeb356de16a27d52fe83d31a5b750",
"assets/assets/img/images/RouteNavigation/ic_date.png": "682aeeb788ff9982c45dca5330172e29",
"assets/assets/img/images/RouteNavigation/ic_home.png": "fc099ea6a6e7bbcbd979af8474713bcb",
"assets/assets/img/images/RouteNavigation/ic_profile.png": "4ed31ef2559e78acb3ce6075393ccb74",
"assets/assets/img/images/splash/ir_circle.png": "c24e1070ae685520e2fe7c383919651f",
"assets/assets/img/images/splash/splash_screen.png": "39c000bc29d6f908e862a62e644e5be2",
"assets/assets/img/images/splash/usa_circle.png": "979cddc0464fd897f0c56555d30917bf",
"assets/assets/img/images/Wallet/ic_image.png": "26e96e86064e7d0efb90f427634f5dae",
"assets/assets/img/images/Wallet/img_background.png": "f637302b91d8f8775b41122783c47ce6",
"assets/FontManifest.json": "2911e51419ed69ba9b454f361ee27cb0",
"assets/fonts/MaterialIcons-Regular.otf": "552cf4ade460e6e868650fba465bfff1",
"assets/NOTICES": "970b40cb1e118bddba4fb8612c193f28",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "4c547ada6c164a77a3cfce8b7feee86d",
"assets/packages/flutter_sound/assets/js/async_processor.js": "1665e1cb34d59d2769956d2f14290274",
"assets/packages/flutter_sound/assets/js/tau_web.js": "32cc693445f561133647b10d1b97ca07",
"assets/packages/flutter_sound_web/howler/howler.js": "3030c6101d2f8078546711db0d1a24e9",
"assets/packages/flutter_sound_web/src/flutter_sound.js": "3c26fcc60917c4cbaa6a30a231f7d4d8",
"assets/packages/flutter_sound_web/src/flutter_sound_player.js": "b14f8d190230d77c02ffc51ce962ce80",
"assets/packages/flutter_sound_web/src/flutter_sound_recorder.js": "0ec45f8c46d7ddb18691714c0c7348c8",
"assets/packages/flutter_sound_web/src/flutter_sound_stream_processor.js": "48d52b8f36a769ea0e90cf9e58eddfa7",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"canvaskit/canvaskit.js": "140ccb7d34d0a55065fbd422b843add6",
"canvaskit/canvaskit.js.symbols": "58832fbed59e00d2190aa295c4d70360",
"canvaskit/canvaskit.wasm": "07b9f5853202304d3b0749d9306573cc",
"canvaskit/chromium/canvaskit.js": "5e27aae346eee469027c80af0751d53d",
"canvaskit/chromium/canvaskit.js.symbols": "193deaca1a1424049326d4a91ad1d88d",
"canvaskit/chromium/canvaskit.wasm": "24c77e750a7fa6d474198905249ff506",
"canvaskit/skwasm.js": "1ef3ea3a0fec4569e5d531da25f34095",
"canvaskit/skwasm.js.symbols": "0088242d10d7e7d6d2649d1fe1bda7c1",
"canvaskit/skwasm.wasm": "264db41426307cfc7fa44b95a7772109",
"canvaskit/skwasm_heavy.js": "413f5b2b2d9345f37de148e2544f584f",
"canvaskit/skwasm_heavy.js.symbols": "3c01ec03b5de6d62c34e17014d1decd3",
"canvaskit/skwasm_heavy.wasm": "8034ad26ba2485dab2fd49bdd786837b",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"flutter.js": "888483df48293866f9f41d3d9274a779",
"flutter_bootstrap.js": "324098b1526f8c2db1cc8a0e45c8afae",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"index.html": "8e64423a37875175a1415b38e555ab50",
"/": "8e64423a37875175a1415b38e555ab50",
"main.dart.js": "7479d7c9f62b86848a303f92d2accecb",
"manifest.json": "f586175e22a602e2f24e1f3ec8c30191",
"version.json": "cae93e21d3ad3b4a7fac8fa28ed45338"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
